/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2006-04-25
 * Description : a widget to use in first run dialog
 *
 * Copyright (C) 2006-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqvariant.h>
#include <tqlabel.h>
#include <tqframe.h>
#include <kurlrequester.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

// KDE includes.

#include <kdialog.h>
#include <tdelocale.h>

// Local includes.

#include "firstrun.h"
#include "firstrun.moc"

namespace Digikam
{

FirstRunWidget::FirstRunWidget( TQWidget* parent )
              : TQWidget( parent )
{
    setName( "FirstRunWidget" );
    TQVBoxLayout *vlayout = new TQVBoxLayout( this, 0, 6 ); 

    m_textLabel2 = new TQLabel( this );
    vlayout->addWidget( m_textLabel2 );

    TQFrame *line1 = new TQFrame( this );
    line1->setFrameShape( TQFrame::HLine );
    line1->setFrameShadow( TQFrame::Sunken );
    line1->setFrameShape( TQFrame::HLine );
    vlayout->addWidget( line1 );

    TQGridLayout *grid = new TQGridLayout( 0, 1, 1, 0, 6 ); 

    m_pixLabel = new TQLabel( this );
    m_pixLabel->setAlignment( int( TQLabel::AlignTop ) );
    grid->addMultiCellWidget( m_pixLabel, 0, 1, 0, 0 );

    m_path = new KURLRequester( this );
    m_path->setShowLocalProtocol( true );

    grid->addWidget( m_path, 1, 1 );

    m_textLabel1 = new TQLabel( this );
    m_textLabel1->setAlignment( int( TQLabel::WordBreak | TQLabel::AlignVCenter ) );
    grid->addWidget( m_textLabel1, 0, 1 );
    
    vlayout->addLayout( grid );
    vlayout->addItem( new TQSpacerItem( 16, 16, TQSizePolicy::Minimum, TQSizePolicy::MinimumExpanding ) );
    
    languageChange();
    resize( TQSize(479, 149).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
}

FirstRunWidget::~FirstRunWidget()
{
}

void FirstRunWidget::languageChange()
{
    m_textLabel2->setText( i18n( "<b>Albums Library Folder</b>" ) );
    m_pixLabel->setText( TQString() );
    m_textLabel1->setText( i18n( "<p>digiKam will store the photo albums which you create in a "
                                 "common <b>Albums Library Folder</b>. "
                                 "Below, please select which folder you would like "
                                 "digiKam to use as the common Albums Library Folder.</p>" 
                                 "<p><b>Do not use a mount path hosted by a remote computer.</b></p>") );
}

}  // namespace Digikam
