/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-04-21
 * Description : Album informations container.
 *
 * Copyright (C) 2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef ALBUMINFO_H
#define ALBUMINFO_H

/** @file albuminfo.h */

// TQt includes.

#include <tqstring.h>
#include <tqvaluelist.h>
#include <tqdatetime.h>

// KDE includes.

#include <kurl.h>

namespace Digikam
{

/**
 * \class AlbumInfo
 * A container class for transporting album information
 * from the database to AlbumManager
 */
class AlbumInfo
{
public:

    typedef TQValueList<AlbumInfo> List;

    int      id;
    TQString  url;
    TQString  caption;
    TQString  collection;
    TQDate    date;
    TQString  icon;

    /**
     * needed for sorting
     */
    bool operator<(const AlbumInfo& info)
    {
        return url < info.url;
    }
};

/**
 * \class TagInfo
 * A container class for transporting tag information
 * from the database to AlbumManager
 */
class TagInfo
{
public:

    typedef TQValueList<TagInfo> List;

    int      id;
    int      pid;
    TQString  name;
    TQString  icon;
};

/**
 * \class SearchInfo
 * A container class for transporting search information
 * from the database to AlbumManager
 */
class SearchInfo
{
public:

    typedef TQValueList<SearchInfo> List;

    int      id;
    TQString  name;
    KURL     url;

    /**
     * needed for sorting
     */
    bool operator<(const SearchInfo& info)
    {
        return id < info.id;
    }
};

}  // namespace Digikam

#endif /* ALBUMINFO_H */
