/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 * 
 * Date        : 2004-10-05
 * Description : a tool bar for slideshow 
 * 
 * Copyright (C) 2004-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

// TQt includes.

#include <tqtoolbutton.h>
#include <tqlayout.h>
#include <tqpixmap.h>

// KDE includes.

#include <tdeapplication.h>
#include <kiconloader.h>
#include <tdelocale.h>

// Local includes.

#include "toolbar.h"
#include "toolbar.moc"

namespace Digikam
{

class ToolBarPriv
{
public:

    ToolBarPriv()
    {
        playBtn = 0;
        stopBtn = 0;
        nextBtn = 0;
        prevBtn = 0;
        canHide = true;
    }

    bool         canHide;

    TQToolButton *playBtn;
    TQToolButton *stopBtn;
    TQToolButton *nextBtn;
    TQToolButton *prevBtn;
};  

ToolBar::ToolBar(TQWidget* parent)
       : TQWidget(parent)
{
    d = new ToolBarPriv;

    TQHBoxLayout* lay = new TQHBoxLayout(this);
    d->playBtn = new TQToolButton(this);
    d->prevBtn = new TQToolButton(this);
    d->nextBtn = new TQToolButton(this);
    d->stopBtn = new TQToolButton(this);
    d->playBtn->setToggleButton(true);

    TDEIconLoader* loader = tdeApp->iconLoader();
    d->playBtn->setIconSet(loader->loadIcon("media-playback-pause", TDEIcon::NoGroup, 22));
    d->prevBtn->setIconSet(loader->loadIcon("back", TDEIcon::NoGroup, 22));
    d->nextBtn->setIconSet(loader->loadIcon("forward", TDEIcon::NoGroup, 22));
    d->stopBtn->setIconSet(loader->loadIcon("process-stop", TDEIcon::NoGroup, 22));

    lay->addWidget(d->playBtn);
    lay->addWidget(d->prevBtn);
    lay->addWidget(d->nextBtn);
    lay->addWidget(d->stopBtn);

    setBackgroundMode(TQt::NoBackground);
    adjustSize();
    setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);
    
    connect(d->playBtn, TQ_SIGNAL(toggled(bool)),
            this, TQ_SLOT(slotPlayBtnToggled()));

    connect(d->nextBtn, TQ_SIGNAL(clicked()),
            this, TQ_SLOT(slotNexPrevClicked()));

    connect(d->prevBtn, TQ_SIGNAL(clicked()),
            this, TQ_SLOT(slotNexPrevClicked()));

    connect(d->nextBtn, TQ_SIGNAL(clicked()),
            this, TQ_SIGNAL(signalNext()));

    connect(d->prevBtn, TQ_SIGNAL(clicked()),
            this, TQ_SIGNAL(signalPrev()));

    connect(d->stopBtn, TQ_SIGNAL(clicked()),
            this, TQ_SIGNAL(signalClose()));
}

ToolBar::~ToolBar()
{
    delete d;    
}

bool ToolBar::canHide() const
{
    return d->canHide;    
}

bool ToolBar::isPaused() const
{
    return d->playBtn->isOn();
}

void ToolBar::setPaused(bool val)
{
    if (val == isPaused())
        return;

    d->playBtn->setOn(val);
    slotPlayBtnToggled();
}

void ToolBar::setEnabledPlay(bool val)
{
    d->playBtn->setEnabled(val);    
}

void ToolBar::setEnabledNext(bool val)
{
    d->nextBtn->setEnabled(val);    
}

void ToolBar::setEnabledPrev(bool val)
{
    d->prevBtn->setEnabled(val);    
}

void ToolBar::slotPlayBtnToggled()
{
    if (d->playBtn->isOn())
    {
        d->canHide = false;
        TDEIconLoader* loader = tdeApp->iconLoader();
        d->playBtn->setIconSet(loader->loadIcon("media-playback-start", TDEIcon::NoGroup, 22));
        emit signalPause();
    }
    else
    {
        d->canHide = true;
        TDEIconLoader* loader = tdeApp->iconLoader();
        d->playBtn->setIconSet(loader->loadIcon("media-playback-pause", TDEIcon::NoGroup, 22));
        emit signalPlay();
    }
}

void ToolBar::slotNexPrevClicked()
{
    if (!d->playBtn->isOn())
    {
        d->playBtn->setOn(true);
        d->canHide = false;
        TDEIconLoader* loader = tdeApp->iconLoader();
        d->playBtn->setIconSet(loader->loadIcon("media-playback-start", TDEIcon::NoGroup, 22));
        emit signalPause();
    }
}

void ToolBar::keyPressEvent(TQKeyEvent *event)
{
    switch(event->key())
    {
        case(TQt::Key_Space):
        {
            if (d->playBtn->isEnabled())
                d->playBtn->animateClick();
            break;
        }
        case(TQt::Key_Prior):
        {
            if (d->prevBtn->isEnabled())
                d->prevBtn->animateClick();
            break;
        }
        case(TQt::Key_Next):
        {
            if (d->nextBtn->isEnabled())
                d->nextBtn->animateClick();
            break;
        }
        case(TQt::Key_Escape):
        {
            if (d->stopBtn->isEnabled())
                d->stopBtn->animateClick();
            break;
        }
        default:
            break;
    }

    event->accept();
}

}   // Namespace Digikam

