/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-05-20
 * Description : search results item.
 *
 * Copyright (C) 2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * ============================================================ */

#ifndef SEARCHRESULTSITEM_H
#define SEARCHRESULTSITEM_H

// TQt includes.

#include <tqiconview.h>

namespace Digikam
{

class SearchResultsItem : public TQIconViewItem
{
    friend class SearchResultsView;

public:

    SearchResultsItem(TQIconView* view, const TQString& path);
    ~SearchResultsItem();

protected:

    void calcRect(const TQString& text = TQString());
    void paintItem (TQPainter * p, const TQColorGroup & cg);
    void paintFocus (TQPainter * p, const TQColorGroup & cg);

private:

    static TQPixmap* m_basePixmap;
    bool            m_marked;
    TQString         m_path;
};    
    
}  // namespace Digikam

#endif /* SEARCHRESULTSITEM_H */
