/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2003-01-28
 * Description : a dialog to display camera information.
 * 
 * Copyright (C) 2003-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

// TQt includes.

#include <tqlayout.h>
#include <tqframe.h>
#include <tqtextedit.h>

// KDE includes.

#include <tdelocale.h>
#include <kiconloader.h>

// Local includes.

#include "camerainfodialog.h"

namespace Digikam
{

CameraInfoDialog::CameraInfoDialog(TQWidget *parent, const TQString& summary, const TQString& manual,
                                   const TQString& about)
                : KDialogBase(IconList, i18n("Camera Information"), Help|Ok, Ok, parent, 0, true, true)
{
    setHelp("digitalstillcamera.anchor", "digikam");
    resize(500, 400);

    // ----------------------------------------------------------
    
    TQFrame *p1 = addPage( i18n("Summary"), i18n("Camera Summary"), BarIcon("contents2", TDEIcon::SizeMedium) );
    TQVBoxLayout *p1layout = new TQVBoxLayout( p1, 0, 6 );

    TQTextEdit *summaryView = new TQTextEdit(summary, TQString(), p1);
    summaryView->setWordWrap(TQTextEdit::WidgetWidth);
    summaryView->setReadOnly(true);
    p1layout->addWidget(summaryView);

    // ----------------------------------------------------------

    TQFrame *p2 = addPage( i18n("Manual"), i18n("Camera Manual"), BarIcon("contents", TDEIcon::SizeMedium) );
    TQVBoxLayout *p2layout = new TQVBoxLayout( p2, 0, 6 );

    TQTextEdit *manualView = new TQTextEdit(manual, TQString(), p2);
    manualView->setWordWrap(TQTextEdit::WidgetWidth);
    manualView->setReadOnly(true);
    p2layout->addWidget(manualView);

    // ----------------------------------------------------------

    TQFrame *p3 = addPage( i18n("About"), i18n("About Driver"), BarIcon("camera-photo", TDEIcon::SizeMedium) );
    TQVBoxLayout *p3layout = new TQVBoxLayout( p3, 0, 6 );
    
    TQTextEdit *aboutView = new TQTextEdit(about, TQString(), p3);
    aboutView->setWordWrap(TQTextEdit::WidgetWidth);
    aboutView->setReadOnly(true);
    p3layout->addWidget(aboutView);
}

CameraInfoDialog::~CameraInfoDialog()
{
}

}  // namespace Digikam
