/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <tqstring.h>
#include <tqdom.h>
#include <tqstringlist.h>
#include <tqfile.h>

#include "xmlwork.h"

TQDomDocument* XMLWork::openFile(const TQString &name, const TQString &filePath)
{
	TQDomDocument *doc = new TQDomDocument(name);
	TQFile file(filePath);
	if ( ! file.open(IO_ReadOnly) ) {
		// TQMessageBox::information(this, "Load an XML file", "Error : un-openable file");
		delete doc;
		return 0;
	}
	if ( ! doc->setContent(&file) ) {
		// TQMessageBox::information(this, "Load an XML file", "Error : malformed content");
		file.close();
		delete doc;
		return 0;
	}
	file.close();
	return doc;
}

TQDomElement XMLWork::getElement(const TQDomElement &startElement, const TQString &elementPath)
{
	TQStringList elements = TQStringList::split("/", elementPath, false);
	TQDomNode n = startElement.firstChild();
	for (unsigned int i = 0; i < elements.count(); ++i) {               // For each elements
		while ( ! n.isNull() ) {                                        // Browse theire sub elements
			TQDomElement e = n.toElement();                              //  and search the good one
			if ( (!e.isNull()) && e.tagName() == *elements.at(i) ) {    // If found
				if ( i + 1 == elements.count() )                        // And if it is the asked element
					return e;                                           // Return the first corresponding
				else {                                                  // Or if it is an intermediate element
					n = e.firstChild();                                 // Continue with the next sub element
					break;
				}
			}
			n = n.nextSibling();
		}
	}
	return TQDomElement();                                               // Not found !
}

TQString XMLWork::getElementText(const TQDomElement &startElement, const TQString &elementPath, const TQString &defaultTxt)
{
	TQDomElement e = getElement(startElement, elementPath);
	if (e.isNull())
		return defaultTxt;
	else
		return e.text();
}

void XMLWork::addElement(TQDomDocument &document, TQDomElement &parent, const TQString &name, const TQString &text)
{
	TQDomElement tag = document.createElement(name);
	parent.appendChild(tag);
	TQDomText content = document.createTextNode(text);
	tag.appendChild(content);
}

bool XMLWork::trueOrFalse(const TQString &value, bool defaultValue)
{
	if ( value == "true"  || value == "1" || value == "on"  || value == "yes" )
		return true;
	if ( value == "false" || value == "0" || value == "off" || value == "no"  )
		return false;
	return defaultValue;
}

TQString XMLWork::trueOrFalse(bool value)
{
	return value ? "true" : "false";
}

TQString XMLWork::innerXml(TQDomElement &element)
{
	TQString inner;
	for (TQDomNode n = element.firstChild(); !n.isNull(); n = n.nextSibling())
		if (n.isCharacterData())
			inner += n.toCharacterData().data();
		else if (n.isElement()) {
			TQDomElement e = n.toElement();
			inner += "<" + e.tagName() + ">" + innerXml(e) + "</" + e.tagName() + ">";
		}
	return inner;
}
