/***************************************************************************
                       amarokslider.h  -  description
                          -------------------
 begin                : Dec 15 2003
 copyright            : (C) 2003 by Mark Kretschmann
 email                : markey@web.de
 copyright            : (C) 2005 by Gábor Lehel
 email                : illissius@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AMAROKSLIDER_H
#define AMAROKSLIDER_H

#include <config.h>
#include "metabundle.h"

#include <kpixmap.h>
#include <kurl.h>

#include <tqpixmap.h>
#include <tqslider.h>
#include <tqvaluevector.h>

class TQPalette;
class TQTimer;

namespace Amarok
{
    class Slider : public TQSlider
    {
        TQ_OBJECT
  

        public:
            Slider( TQt::Orientation, TQWidget*, uint max = 0 );

            virtual void setValue( int );

            //WARNING non-virtual - and thus only really intended for internal use
            //this is a major flaw in the class presently, however it suits our
            //current needs fine
            int value() const { return adjustValue( TQSlider::value() ); }

        signals:
            //we emit this when the user has specifically changed the slider
            //so connect to it if valueChanged() is too generic
            //TQt also emits valueChanged( int )
            void sliderReleased( int );

        protected:
            virtual void wheelEvent( TQWheelEvent* );
            virtual void mouseMoveEvent( TQMouseEvent* );
            virtual void mouseReleaseEvent( TQMouseEvent* );
            virtual void mousePressEvent( TQMouseEvent* );
            virtual void slideEvent( TQMouseEvent* );

            bool m_sliding;

            /// we flip the value for vertical sliders
            int adjustValue( int v ) const
            {
               int mp = (minValue() + maxValue()) / 2;
               return orientation() == TQt::Vertical ? mp - (v - mp) : v;
            }

        private:
            bool m_outside;
            int  m_prevValue;

            Slider( const Slider& ); //undefined
            Slider &operator=( const Slider& ); //undefined
    };


    class PrettySlider : public Slider
    {
        TQ_OBJECT
  

        public:
            typedef enum
            {
                Normal,  // Same behavior as Slider *unless* there's a moodbar
                Pretty
            } SliderMode;

            PrettySlider( TQt::Orientation orientation, SliderMode mode,
                          TQWidget *parent, uint max = 0 );

            virtual void newBundle( const MetaBundle &bundle );

        protected:
            virtual void paintEvent( TQPaintEvent *e );
            virtual void slideEvent( TQMouseEvent* );
            virtual void mousePressEvent( TQMouseEvent* );

        protected slots:
            void moodbarJobEvent( int newState );
            void slotMoodbarPrefs( bool show, bool moodier, int alter, bool withMusic );

        private:
            PrettySlider( const PrettySlider& ); //undefined
            PrettySlider &operator=( const PrettySlider& ); //undefined

            SliderMode m_mode;
            MetaBundle m_bundle;  // Has our moodbar data!
            bool       m_showingMoodbar;
    };

    class VolumeSlider: public Slider
    {
        TQ_OBJECT
  

        public:
            VolumeSlider( TQWidget *parent, uint max = 0 );

        protected:
            virtual void paintEvent( TQPaintEvent* );
            virtual void hideEvent( TQHideEvent* );
            virtual void showEvent( TQShowEvent* );
            virtual void enterEvent( TQEvent* );
            virtual void leaveEvent( TQEvent* );
            virtual void paletteChange( const TQPalette& );
            virtual void slideEvent( TQMouseEvent* );
            virtual void mousePressEvent( TQMouseEvent* );
            virtual void contextMenuEvent( TQContextMenuEvent* );
            virtual void wheelEvent( TQWheelEvent *e );

        private slots:
            virtual void slotAnimTimer();

        private:
            void generateGradient();

            VolumeSlider( const VolumeSlider& ); //undefined
            VolumeSlider &operator=( const VolumeSlider& ); //undefined

            ////////////////////////////////////////////////////////////////
            static const int ANIM_INTERVAL = 18;
            static const int ANIM_MAX = 18;

            bool    m_animEnter;
            int     m_animCount;
            TQTimer* m_animTimer;

            TQPixmap m_pixmapInset;
            KPixmap m_pixmapGradient;

            TQValueVector<TQPixmap> m_handlePixmaps;
    };

}

#endif
