/*
  Copyright (c) 2006 Gábor Lehel <illissius@gmail.com>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#ifndef AMAROK_EXPRESSION_H
#define AMAROK_EXPRESSION_H

#include <tqstring.h>
#include <tqvaluevector.h>

struct expression_element
{
    TQString field;
    TQString text;
    bool negate: 1;
    enum { Contains, Less, More } match: 2;
    expression_element(): negate( false ), match( Contains ) { }
};
typedef TQValueVector<expression_element> or_list;

typedef TQValueVector<or_list> ParsedExpression;

class ExpressionParser
{
    public:
        ExpressionParser( const TQString &expression );
        ParsedExpression parse();
        static ParsedExpression parse( const TQString &expression );

        static bool isAdvancedExpression( const TQString &expression );

    private:
        void parseChar(   const TQChar &c );
        void handleSpace( const TQChar &c );
        void handleMinus( const TQChar &c );
        void handleColon( const TQChar &c );
        void handleMod(   const TQChar &c );
        void handleQuote( const TQChar &c );
        void handleChar(  const TQChar &c );
        void finishedToken();
        void finishedElement();
        void finishedOrGroup();

        const TQString &m_expression;
        enum State { ExpectMinus, ExpectField, ExpectMod, ExpectText };
        int m_state;
        bool m_haveGroup;
        bool m_inQuote;
        bool m_inOrGroup;
        TQString m_string;
        expression_element m_element;
        or_list m_or;
        ParsedExpression m_parsed;
};


#endif
