// This module implements the TQextScintillaLexerMakefile class.
//
// Copyright (c) 2006
// 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
// 
// This file is part of TQScintilla.
// 
// This copy of TQScintilla is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// TQScintilla is supplied in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
// 
// You should have received a copy of the GNU General Public License along with
// TQScintilla; see the file LICENSE.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <tqcolor.h>
#include <tqfont.h>
#include <tqsettings.h>

#include "tqextscintillalexermakefile.h"


// The ctor.
TQextScintillaLexerMakefile::TQextScintillaLexerMakefile(TQObject *parent,const char *name)
	: TQextScintillaLexer(parent,name)
{
}


// The dtor.
TQextScintillaLexerMakefile::~TQextScintillaLexerMakefile()
{
}


// Returns the language name.
const char *TQextScintillaLexerMakefile::language() const
{
	return "Makefile";
}


// Returns the lexer name.
const char *TQextScintillaLexerMakefile::lexer() const
{
	return "makefile";
}


// Return the string of characters that comprise a word.
const char *TQextScintillaLexerMakefile::wordCharacters() const
{
	return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-";
}


// Returns the foreground colour of the text for a style.
TQColor TQextScintillaLexerMakefile::color(int style) const
{
	switch (style)
	{
	case Default:
	case Operator:
		return TQColor(0x00,0x00,0x00);

	case Comment:
		return TQColor(0x00,0x7f,0x00);

	case Preprocessor:
		return TQColor(0x7f,0x7f,0x00);

	case Variable:
		return TQColor(0x00,0x00,0x80);

	case Target:
		return TQColor(0xa0,0x00,0x00);

	case Error:
		return TQColor(0xff,0xff,0x00);
	}

	return TQextScintillaLexer::color(style);
}


// Returns the end-of-line fill for a style.
bool TQextScintillaLexerMakefile::eolFill(int style) const
{
	return (style == Error);
}


// Returns the font of the text for a style.
TQFont TQextScintillaLexerMakefile::font(int style) const
{
	TQFont f;

	if (style == Comment)
#if defined(Q_OS_WIN)
		f = TQFont("Comic Sans MS",9);
#else
		f = TQFont("Bitstream Vera Serif",9);
#endif
	else
		f = TQextScintillaLexer::font(style);

	return f;
}


// Returns the user name of a style.
TQString TQextScintillaLexerMakefile::description(int style) const
{
	switch (style)
	{
	case Default:
		return tr("Default");

	case Comment:
		return tr("Comment");

	case Preprocessor:
		return tr("Preprocessor");

	case Variable:
		return tr("Variable");

	case Operator:
		return tr("Operator");

	case Target:
		return tr("Target");

	case Error:
		return tr("Error");
	}

	return TQString();
}


// Returns the background colour of the text for a style.
TQColor TQextScintillaLexerMakefile::paper(int style) const
{
	if (style == Error)
		return TQColor(0xff,0x00,0x00);

	return TQextScintillaLexer::paper(style);
}

#include "tqextscintillalexermakefile.moc"
