###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )
find_package( TQt )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


if( BUILD_TQCA )
##### look for tqt3 headers path

pkg_get_variable(
      TQT_HEADERS_DIRS
      tqt-mt
      includedir
)
endif( BUILD_TQCA )


if( BUILD_TQCA_TLS )
##### check for openssl

pkg_search_module( SSL openssl )

if( NOT SSL_FOUND )
    check_include_file( openssl/ssl.h HAVE_OPENSSL_H )
    check_library_exists( ssl OPENSSL_init_ssl "" HAVE_LIBSSL_11 )
    check_library_exists( crypto EVP_EncryptInit_ex "" HAVE_LIBCRYPTO )

    if( NOT HAVE_LIBSSL_11 )
        check_library_exists( ssl SSL_library_init "" HAVE_LIBSSL )
    endif()

    if( HAVE_OPENSSL_H AND HAVE_LIBCRYPTO AND (HAVE_LIBSSL_11 OR HAVE_LIBSSL)  )
        set( SSL_FOUND 1 CACHE INTERNAL "" FORCE )
        find_file( OPENSSLV_H openssl/opensslv.h )
        file( STRINGS "${OPENSSLV_H}" SSL_VERSION REGEX "#[ \t]*define[ \t]*OPENSSL_VERSION_TEXT" )
        string( REGEX REPLACE "# *define[ \t]*OPENSSL_VERSION_TEXT[ \t]*\"[^0-9 ]* *([^ ]*).*" "\\1" SSL_VERSION "${SSL_VERSION}" )
        set( SSL_VERSION "${SSL_VERSION}" CACHE INTERNAL "" FORCE )
        set( SSL_LIBRARIES "ssl;crypto" CACHE INTERNAL "ssl and crypto libs" FORCE )
    endif()
endif( NOT SSL_FOUND )

if( NOT SSL_FOUND )
    tde_message_fatal( "OpenSSL is required but was not found on your system" )
endif()


##### look for tqt3 plugins path

pkg_get_variable(
      TQT_PLUGINS_DIR
      tqt-mt
      pluginsdir
)
if( TQT_PLUGINS_DIR )
    set( TQT_PLUGINS_CRYPTO_DIR "${TQT_PLUGINS_DIR}/crypto" )
endif()
endif( BUILD_TQCA_TLS )
