/****************************************************************************
 ** $Id: testprivacyproxy.cpp,v 1.2 2008/08/20 16:49:31 hoganrobert Exp $
 *   Copyright (C) 2006 - 2008 Robert Hogan                                *
 *   robert@roberthogan.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/

#include <tqsocket.h>
#include <tqtextstream.h>
#include <tqfile.h>
#include <tqdir.h>
#include <tqtimer.h>

#include <kstandarddirs.h>
#include <tdelocale.h>

#include <assert.h>
#include <sys/socket.h>
#include <netdb.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "testprivacyproxy.h"
#include "tork.h"
#include "torkconfig.h"

TestPrivoxy::TestPrivoxy( )
{
    // create the socket and connect various of its signals
    socket = new TQSocket( this );
    connect( socket, TQ_SIGNAL(connected()),
            TQ_SLOT(socketConnected()) );
    connect( socket, TQ_SIGNAL(connectionClosed()),
            TQ_SLOT(socketConnectionClosed()) );
/*    connect( socket, TQ_SIGNAL(readyRead()),
            TQ_SLOT(socketReadyRead()) );*/
    connect( socket, TQ_SIGNAL(error(int)),
            TQ_SLOT(socketError(int)) );


}

void TestPrivoxy::connectTo(const TQString &host, TQ_UINT16 port )
{
    // connect to the server
    socket->connectToHost( host, port );
}

TestPrivoxy::~TestPrivoxy( )
{
}

#include "testprivacyproxy.moc"

