/***************************************************************************
                          execbutton.h - Button that runs its text association 
                             -------------------
    copyright            : (C) 2002-2003 Marc Britton <consume@optusnet.com.au>
                           (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _HAVE_EXECBUTTON_H_
#define _HAVE_EXECBUTTON_H_

/* KDE INCLUDES */
#include <kpushbutton.h>

/* QT INCLUDES */
#include <tqobject.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <kommander_export.h>

class TQWidget;
class TDEProcess;
class MyProcess;

class TQShowEvent;
class KOMMANDER_EXPORT ExecButton : public KPushButton, public KommanderWidget
{
  TQ_OBJECT
  

  TQ_ENUMS(Blocking)
  TQ_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  TQ_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  TQ_PROPERTY(bool KommanderWidget READ isKommanderWidget)
  TQ_PROPERTY(bool writeStdout READ writeStdout WRITE setWriteStdout)
  TQ_PROPERTY(Blocking blockGUI READ blockGUI WRITE setBlockGUI)

public:
  ExecButton(TQWidget *a_parent, const char *a_name);
  ~ExecButton();

  virtual bool isKommanderWidget() const;
  virtual void setAssociatedText(const TQStringList&);
  virtual TQStringList associatedText() const;
  virtual TQString currentState() const;

  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);

  // Handle stdout setting
  virtual void setWriteStdout(bool);
  bool writeStdout() const;
  // Handle blocking
  enum Blocking { None, Button, GUI };
  virtual void setBlockGUI(Blocking a_enable);
  Blocking blockGUI() const;
  
  virtual TQString handleDCOP(int function, const TQStringList& args);
  virtual bool isFunctionSupported(int function);
public slots:
  virtual void populate();
  virtual void setWidgetText(const TQString &);
  
  // Execute script from associastedText
  virtual void startProcess();
  // Process has ended
  virtual void processExited(MyProcess* p);
signals:
  void widgetOpened();
  void widgetTextChanged(const TQString&);
  void contextMenuRequested(int xpos, int ypos);

protected:
  void contextMenuEvent( TQContextMenuEvent * e );
  // Whether output from process should be put in real stdout
  bool m_writeStdout;
  // Whether pressing execubtton should block GUI until process ends
  Blocking m_blockGUI;
  // Output from process
  TQString m_output;
  void showEvent( TQShowEvent *e );
private:
};

#endif
