/*
 * soundpage.h
 *
 * Copyright (c) 1998 David Faure
 *
 * Requires the TQt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef __KCONTROL_KSOUNDPAGE_H__
#define __KCONTROL_KSOUNDPAGE_H__

#include <tqdir.h>
/* has to be before everything because of #define Unsorted 0 in X11/X.h !! */

#include <tqobject.h>

#include <tdecmodule.h>


class TQDragMoveEvent;
class TQDragEnterEvent;
class TQDropEvent;

class KSimpleConfig;
class KURLRequester;
class TQCheckBox;
class TQLabel;
class TQListBox;
class TQPushButton;

class KSoundPageConfig : public TDECModule
{
  TQ_OBJECT
  

public:
    KSoundPageConfig( TQWidget *parent=0, const char* name=0,
			KSimpleConfig *config=0, KSimpleConfig *announceconfig=0);
    ~KSoundPageConfig( );
	
    void load();
    void save();
    void defaults();

    bool eventFilter(TQObject* o, TQEvent* e);

private slots:
    void soundOnOff();
    void playCurrentSound();
    void slotChanged();

    // Sound DnD
    void sound_listDragEnterEvent(TQDragEnterEvent* e);
    void sound_listDropEvent(TQDropEvent* e);
 
private:
	KSimpleConfig *config;
	KSimpleConfig *announceconfig;
	bool delete_config;

    TQLabel *extprg_label;
    KURLRequester *extprg_edit;
    TQLabel *client_label;
    KURLRequester *client_edit;
    TQCheckBox *sound_cb;
    TQLabel *sound_label;
    TQListBox *sound_list;
    TQLabel *sound_tip;
    TQPushButton *btn_test;

    int findInSound_List(TQString sound);
    bool addToSound_List(TQString sound);
};

#endif

