/*
 * kPPPlogview: a accounting log system for kPPP
 *
 *            Copyright (C) 1998 Mario Weilguni <mweilguni@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <tdeapplication.h>
#include "log.h"
#include "monthly.h"
#include "main.h"
#include <tdelocale.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>
#include <kiconloader.h>

#define F_EXIT     101


static const char description[] =
	I18N_NOOP("KPPP log viewer");

static const char version[] = "v0.0.2";

static TDECmdLineOptions option[] =
{
   { "kppp", I18N_NOOP("Run in KPPP mode"), 0 },
   TDECmdLineLastOption
};


TopWidget::TopWidget() : TDEMainWindow(0, "") {
  // Check command line args for "-kppp"

  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
  bool kpppmode = args->isSet("kppp");
  args->clear();

  setCaption(i18n("KPPP Log Viewer"));

  w = new TQWidget(this);

  TQBoxLayout *l = new TQVBoxLayout(w, 5);

  td = new TQTabWidget(w, "");
  mw = new MonthlyWidget(td);
  td->addTab(mw, i18n("Monthly Log"));
  l->addWidget(td);

  // remove buttons
  if(!kpppmode) {
    // create menu
    mb = new KMenuBar(this);
    TQPopupMenu *fm = new TQPopupMenu;
    fm->insertItem(SmallIcon("system-log-out"),KStdGuiItem::quit().text(), F_EXIT);
    mb->insertItem(i18n("&File"), fm);

    mb->setAccel(CTRL + Key_Q, F_EXIT);
    connect(mb, TQ_SIGNAL(activated(int)),
	    this, TQ_SLOT(menuCallback(int)));
  } else {
    mb = 0;
    TQPushButton *but = new KPushButton(KStdGuiItem::close(),w);
    TQHBoxLayout *lh = new TQHBoxLayout(l);
    lh->addStretch(10);
    lh->addWidget(but);

    connect(but, TQ_SIGNAL(clicked()),
	    kapp, TQ_SLOT(quit()));
  }

  setMinimumSize(mw->sizeHint().width() + 15,
                 mw->sizeHint().height() + 120);
  setCentralWidget(w);
}

TopWidget::~TopWidget() {
}

void TopWidget::menuCallback(int id) {
  switch(id) {
  case F_EXIT:
    exit(0);
    break;
  }
}

int main(int argc, char **argv) {
  TDEAboutData aboutData("kppplogview", I18N_NOOP("KPPP Log Viewer"),
    version, description, TDEAboutData::License_GPL,
    I18N_NOOP("(c) 1999-2002, The KPPP Developers"));
  aboutData.addAuthor("Bernd Wuebben",0, "wuebben@kde.org");
  aboutData.addAuthor("Mario Weilguni",0, "");
  aboutData.addAuthor("Harri Porten",0, "porten@kde.org");
  TDECmdLineArgs::init(argc, argv, &aboutData);

  TDECmdLineArgs::addCmdLineOptions( option );

  TDEApplication a;

  loadLogs();

  TopWidget *w = new TopWidget;
  w->show();
  a.setMainWidget(w);

  return a.exec();
}

#include "main.moc"
