/*
    yahoobuddyiconloader.cpp - Fetches YahooBuddyIcons

    Copyright (c) 2005 by André Duffeck <duffeck@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "yahoobuddyiconloader.h"

// QT Includes
#include <tqfile.h>

// KDE Includes
#include <kdebug.h>
#include <tdetempfile.h>
#include <tdeio/global.h>
#include <tdeio/job.h>
#include <tdeio/jobclasses.h>
#include <kurl.h>
#include <kstandarddirs.h>
#include <tdelocale.h>

#include "yahootypes.h"
#include "client.h"

YahooBuddyIconLoader::YahooBuddyIconLoader( Client *c )
: m_client( c )
{
}

YahooBuddyIconLoader::~YahooBuddyIconLoader()
{
}

void YahooBuddyIconLoader::fetchBuddyIcon( const TQString &who, KURL url, int checksum )
{
	kdDebug(YAHOO_RAW_DEBUG) << k_funcinfo << url << endl;
	TDEIO::TransferJob *transfer;
	TQString Url = url.url();
	TQString ext = Url.left( Url.findRev( "?" ) );
	ext = ext.right( ext.length() - ext.findRev( "." ) );

	transfer = TDEIO::get( url, false, false );
	connect( transfer, TQ_SIGNAL( result( TDEIO::Job* ) ), this, TQ_SLOT( slotComplete( TDEIO::Job* ) ) );
	connect( transfer, TQ_SIGNAL( data( TDEIO::Job*, const TQByteArray& ) ), this, TQ_SLOT( slotData( TDEIO::Job*, const TQByteArray& ) ) );

	m_jobs[transfer].url = url;
	m_jobs[transfer].who = who;
	m_jobs[transfer].checksum = checksum;

}

void YahooBuddyIconLoader::slotData( TDEIO::Job *job, const TQByteArray& data )
{
	kdDebug(YAHOO_GEN_DEBUG) << k_funcinfo << endl;

	TDEIO::TransferJob *transfer = static_cast< TDEIO::TransferJob * >(job);

	// FIXME need to check
	//m_jobs[transfer].icon.append( data );
	int oldsize = m_jobs[transfer].icon.size();
	m_jobs[transfer].icon.resize( data.size() + oldsize );
	memcpy( m_jobs[transfer].icon.data() + oldsize, data.data(), data.size() );
}

void YahooBuddyIconLoader::slotComplete( TDEIO::Job *job )
{
	kdDebug(YAHOO_GEN_DEBUG) << k_funcinfo << endl;

	TDEIO::TransferJob *transfer = static_cast< TDEIO::TransferJob * >(job);

	if ( job->error () || transfer->isErrorPage () )
	{
		kdDebug(YAHOO_RAW_DEBUG) << "An error occurred while downloading buddy icon." << endl;
		if( m_client )
			m_client->notifyError( i18n( "An error occurred while downloading a buddy icon (%1)").arg( m_jobs[transfer].url.url() ), job->errorString(), Client::Info );
	}
	else
	{
		emit fetchedBuddyIcon( m_jobs[transfer].who, m_jobs[transfer].icon, m_jobs[transfer].checksum );
	}

	m_jobs.remove( transfer );
}



#include "yahoobuddyiconloader.moc"

