/***************************************************************************
*                                tdefileio.h
*                             -------------------
*
*    Revision     : $Id$
*    begin        : Tue Jan 29 2002
*    copyright    : (C) 2002 by Patrick Charbonnier
*
*    email        : pch@freeshell.org
*
***************************************************************************/

/* Load / save entire (local) files with nice diagnostics dialog messages.
 * These functions load/save the whole buffer in one i/o call, so they
 * should be pretty efficient.
 *
 * Author: Stefan Taferner <taferner@kde.org>
 * This code is under GPL.
 */
#ifndef tdefileio_h
#define tdefileio_h

/** Load a file. Returns a pointer to the memory-block that contains
 * the loaded file. Returns a NULL string if the file could not be loaded.
 * If withDialogs is false no warning dialogs are opened if there are
 * problems.
 * The string returned is always zero-terminated and therefore one
 * byte longer than the file itself.
 * If ensureNewline is true the string will always have a trailing newline.
 */
TQString kFileToString(const TQString & fileName, bool ensureNewline = true, bool withDialogs = true);

/** Save a file. If withDialogs is false no warning dialogs are opened if
 * there are problems. Returns true on success and false on failure.
 * Replaces existing files without warning if askIfExists==false.
 * Makes a copy if the file exists to filename~ if createBackup==true.
 */
bool kCStringToFile(const TQCString & buffer, const TQString & fileName, bool askIfExists = false, bool createBackup = true, bool withDialogs = true);

// Does not stop at NUL
bool kByteArrayToFile(const TQByteArray & buffer, const TQString & fileName, bool askIfExists = false, bool createBackup = true, bool withDialogs = true);


#endif                          /* tdefileio_h */
