#ifndef DCOPIFACE_H
#define DCOPIFACE_H

#include <noatun/player.h>
#include <noatun/plugin.h>

#include <dcopobject.h>
#include <tdemacros.h>

class TDE_EXPORT NIF : public Plugin, public DCOPObject
{
K_DCOP

public:
	NIF();
	~NIF();

private slots:
	void newSongPlaying();

k_dcop:
	void toggleListView();
	void handleButtons();
	void removeCurrent();

	void back();
	void stop();
	void play();
	void playpause();
	void forward();
	void skipTo(int);
	void loop();

	void setVolume(int);
	int volume();
	void volumeUp();
	void volumeDown();
	void toggleMute();

	/**
	 * length in milliseconds
	 **/
	int length();
	/**
	 * position in milliseconds
	 **/
	int position();

	/**
	 * 0 stopped
	 * 1 paused
	 * 2 playing
	 **/
	int state();

	TQString lengthString();
	TQString timeString();

	TQString title();

	/**
	 * set a property for the current song
	 **/
	void setCurrentProperty(const TQString &key, const TQString &value);
	/**
	 * get a property from the current song
	 **/
	TQString currentProperty(const TQString &key);
	/**
	 * clear a property from the current song
	 **/
	void clearCurrentProperty(const TQString &key);

	TQCString visStack();
	TQCString session();

	void addFile(const TQString& f, bool autoplay);
	void addFile(const TQStringList &f, bool autoplay);

	void loadPlugin(const TQString &specFile);
	TQStringList availablePlugins();
	TQStringList loadedPlugins();
	bool unloadPlugin(const TQString &specFile);

	TQStringList mimeTypes();
	TQCString version();

	/**
	 * clear the playlist
	 **/
	void clear();
private:
	int mLastVolume; // remember volume for mute/unmute

#ifdef DOCUMENTATION_BLEH_BLEH_DONT_TRY_COMPILING_THIS
signals:
	void exiting();
	void newFile();

#endif
};

#endif

