#ifndef BASE_FIELD_H
#define BASE_FIELD_H

#include <highscore/kexthighscore.h>

#include <tdemacros.h>

class TQVBoxLayout;
class TQGridLayout;
class KGameLCD;
class KGameLCDList;
class BaseBoard;
class TQLabel;
class TQButton;
class GTInitData;
class KCanvasRootPixmap;

class TDE_EXPORT BaseField
{
 public:
    BaseField(TQWidget *widget);
    virtual ~BaseField() {}
        
    virtual KExtHighscore::Score currentScore() const = 0;
    static void gameOver(const KExtHighscore::Score &, TQWidget *parent);

    virtual void setArcade();
    bool isArcade() const;

 protected:
    TQGridLayout  *top, *lcds;
    KGameLCD     *showScore;
    KGameLCDList *removedList, *scoreList;
    BaseBoard    *board;

    virtual void scoreUpdated();
    virtual void init(bool AI, bool multiplayer, bool server, bool first,
                      const TQString &name);
    virtual void start(const GTInitData &);
    virtual void pause(bool pause);
    virtual void stop(bool gameover);
    virtual void settingsChanged();

 private:
    TQWidget   *_widget;
    struct Flags {
        bool AI, multiplayer, server, first;
    };
    Flags        _flags;
    uint         _arcadeStage;
    TQVBoxLayout *_boardLayout;
    TQLabel      *_label;
    TQButton     *_button;
    KCanvasRootPixmap *_boardRootPixmap;
    KExtHighscore::Score _firstScore, _lastScore;

    enum ButtonType { StartButton = 0, ResumeButton, ProceedButton,
                      NB_BUTTON_TYPE, NoButton = NB_BUTTON_TYPE };
    static const char *BUTTON_TEXTS[NB_BUTTON_TYPE];

    bool hasButton() const { return _flags.server && _flags.first; }
	void setMessage(const TQString &label, ButtonType);
    void hideMessage() { setMessage(TQString(), NB_BUTTON_TYPE); }
};

#endif
