#include "factory.h"

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdeglobal.h>
#include <tdelocale.h>

#include "settings.h"


BaseFactory *BaseFactory::_self = 0;

BaseFactory::BaseFactory(const MainData &md, const BaseBoardInfo &bi)
    : mainData(md), bbi(bi)
{
    Q_ASSERT( _self==0 );
    _self = this;
    _aboutData =
        new TDEAboutData(md.appName, md.trName, md.longVersion, md.description,
                       TDEAboutData::License_GPL,
                       "(c) 1995, Eirik Eng\n(c) 1996-2004, Nicolas Hadacek",
                       0, md.homepage);
    _aboutData->addAuthor("Nicolas Hadacek", 0, "hadacek@kde.org");
    _aboutData->addCredit("Eirik Eng", I18N_NOOP("Core engine"));
}

void BaseFactory::init(int argc, char **argv)
{
    TDECmdLineArgs::init(argc, argv, _aboutData);
    (void)new TDEApplication;
    TDEGlobal::locale()->insertCatalogue("libtdegames");
    TDEGlobal::locale()->insertCatalogue("libksirtet");
}

BaseFactory::~BaseFactory()
{
    delete kapp;
    delete _aboutData;
    Q_ASSERT(_self);
    _self = 0;
}

TQWidget *BaseFactory::createAppearanceConfig()
{
    return new BaseAppearanceConfig;
}

TQWidget *BaseFactory::createColorConfig()
{
    return new ColorConfig;
}
