/****************************************************************
**
** Definition of Molek class,
**
****************************************************************/

#ifndef MOLEK_H
#define MOLEK_H

#include <stdio.h>
#include <stdlib.h>
#include <tqwidget.h>
#include <tqpoint.h>
#include <tqpainter.h>
#include <tqpixmap.h>
#include "atom.h"
#include <tqvaluelist.h>

class KSimpleConfig;

#define MOLEK_SIZE 15

class Molek : public TQWidget
{
    TQ_OBJECT
  

public:
    Molek (TQWidget *parent=0, const char *name=0);
   ~Molek ();

   void load(const KSimpleConfig& config);

   const atom& getAtom(uint index) const;
   int atomSize() const { return atoms.count(); }

   TQSize molecSize() const { return _size; }
   uint getAtom(int x, int y) const { return molek[x][y]; }
   
protected:
   void paintEvent( TQPaintEvent * );

private:
   TQPixmap data;
   uint molek[MOLEK_SIZE][MOLEK_SIZE]; // the indexes within atoms
   TQValueList<atom> atoms;
   TQString mname;
   TQSize _size;


};

#endif // MOLEK_H
