/***************************************************************************
                          ksnewstuff.h  -  description
                             -------------------
    begin                : Wed 21 May 2004
    copyright            : (C) 2004 by Jason Harris
    email                : kstars@30doradus.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/**
	*@class KSNewStuff 
	*Subclass of TDENewStuff, which provides a GUI for downloading extra 
	*application data from the internet.  The KStars version is cutomized to 
	*parse the newly downloaded data and incorporate it immediately into 
	*the program.
	*@note This class is only compiled if the user has KDE >= 3.2.90, because
	*earlier versions of KDE did not have TDENewStuff.
	*@author Jason Harris
	*@version 1.0
	*/

#ifndef KSNEWSTUFF_H
#define KSNEWSTUFF_H

#include <tdeversion.h>

#include <tdelocale.h>
#include <kdebug.h>
#include <tqobject.h>

#include <tdenewstuff/knewstuff.h>

class KDirWatch;
class KStars;

class KSNewStuff : public TQObject, public TDENewStuff
{
	TQ_OBJECT
  
	public:
	/**
		*Constructor
		*@p parent pointer to the parent widget
		*/
		KSNewStuff( TQWidget *parent = 0 );

	/**
		*Install new application data
		*@p fileName the name of the file to be installed
		*@note overloaded from TDENewStuff
		*/
		bool install( const TQString &fileName );

	/**
		*Upload a data file
		*@p fileName The file to upload
		*@note this function is not yet implemented, and is just a placeholder
		*/
		bool createUploadFile( const TQString & /*fileName*/ ) {
			kdDebug() << i18n( "Uploading data is not possible yet!" );
			return false;
		}

	public slots:
	/**
		*Incorporate the newly-downloaded data into the program.
		*This slot is called whenever files are added to the data directory
		*@p newFile The name of the file that was just added to the data directory
		*/
		void updateData( const TQString &newFile );

	/**
		*Simply calls kapp->processEvents(), to make the UI responsive while 
		*new NGC/IC data are being added to the program.
		*/
 		void slotProcessEvents();

	private:
		KDirWatch *kdw;
		KStars *ks;
		bool NGCUpdated;
};

#endif  // KSNEWSTUFF_H
