// Demo of a TQString slot
// Implemented by Marcus Urban

using System;
using Qt;

public class MyWidget : TQVBox
{
	TQLineEdit lineEdit;
	TQLabel label;

	public MyWidget (TQWidget parent, String name) : base (parent, name)
	{
		lineEdit = new TQLineEdit( this, "lineEdit" );
		label = new TQLabel( this, "label" );
		label.SetText("Default");
		
		TQObject.Connect( lineEdit, TQ_SIGNAL("textChanged(TQString)"),
			label, "SetText(TQString)" );
	}


	public MyWidget (TQWidget parent) : this (parent, "") {}
	public MyWidget () : this (null, "") {}
}

public class Example {

	public static int Main (String[] args)
	{
		TQApplication a = new TQApplication (args);
		
		MyWidget w = new MyWidget ();
		a.SetMainWidget (w);
		w.Show ();
		return a.Exec ();
	}
}
