//////////////////////////////////////////////////////////////////////////////
// baghiraconfig.cpp
// -------------------
// Config module for Baghira window decoration
// -------------------
// Copyright (c) 2004 Thomas Lübking
// Please see the header file for copyright and license information.
//////////////////////////////////////////////////////////////////////////////

#include <tdeconfig.h>
#include <tdelocale.h>
#include <tdeglobal.h>
#include <kcolorbutton.h>
#include <tqbutton.h>
#include <tqbuttongroup.h>
#include <tqcombobox.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqfont.h>
#include <tqgroupbox.h>
#include <tqpushbutton.h>
#include <tqradiobutton.h>
#include <tqsettings.h>
#include <tqspinbox.h>
#include <tqwhatsthis.h>

#include "baghiraconfig.h"
#include "configdialog.h"
#include "customdecosettings.h"
#include "pixmaps.h"

//////////////////////////////////////////////////////////////////////////////
// BaghiraConfig Class                                                        //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// BaghiraConfig()
// -------------
// Constructor

BaghiraConfig::BaghiraConfig(TDEConfig*, TQWidget* parent)
    : TQObject(parent), /*config_(0),*/ dialog_(0)
{
//     config_ = new TDEConfig("baghirarc");
//     config_ = new TQSettings;
//     config_->beginGroup("/baghira/Deco");
    TDEGlobal::locale()->insertCatalogue("twin_clients");
    TDEGlobal::locale()->insertCatalogue("twin_baghira");

    dialog_ = new ConfigDialog(parent);
    buttonDialog_ = new ButtonColors(parent, "Button Colors");
    load(0L);
    
    dialog_->show();
    
    connect(dialog_->ButtonColorConfig, TQ_SIGNAL(clicked()), buttonDialog_, TQ_SLOT(exec()));
    connect(buttonDialog_->ok, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
            
    // connections
    connect(dialog_->titlealign, TQ_SIGNAL(clicked(int)), TQ_SIGNAL(changed()));
    connect(dialog_->drawComicFrame, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->addAutoSpacing, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->allowEasyClosing, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->ResizeGrip, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->maxResizable, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->fullSpec, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->noModalDeco, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->delAppname, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->defaultMode, TQ_SIGNAL(activated(int)),  TQ_SIGNAL(changed()));
    connect(dialog_->minTH, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
    
    connect(dialog_->activeColor1_J, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
    connect(dialog_->activeColor2_J, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
    connect(dialog_->inactiveColor1_J, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
    connect(dialog_->inactiveColor2_J, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
    connect(dialog_->buttonStyle_J, TQ_SIGNAL(activated(int)), TQ_SIGNAL(changed()));
    connect(dialog_->shapeUL_J, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->shapeUR_J, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->shapeLL_J, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->shapeLR_J, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->drawIcon_J, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->titleeffect_J, TQ_SIGNAL(activated(int)),  TQ_SIGNAL(changed()));
    connect(dialog_->i_titleeffect_J, TQ_SIGNAL(activated(int)), TQ_SIGNAL(changed()));
    connect(dialog_->_3DImpact_J, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
    connect(dialog_->LineImpact_J, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
   connect(dialog_->borderSize_J, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
            
    connect(dialog_->activeColor1_P, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
    connect(dialog_->activeColor2_P, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
    connect(dialog_->inactiveColor1_P, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
    connect(dialog_->inactiveColor2_P, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
    connect(dialog_->buttonStyle_P, TQ_SIGNAL(activated(int)), TQ_SIGNAL(changed()));
    connect(dialog_->shapeUL_P, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->shapeUR_P, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->shapeLL_P, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->shapeLR_P, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->drawIcon_P, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->titleeffect_P, TQ_SIGNAL(activated(int)), TQ_SIGNAL(changed()));
    connect(dialog_->i_titleeffect_P, TQ_SIGNAL(activated(int)), TQ_SIGNAL(changed()));
    connect(dialog_->_3DImpact_P, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
    connect(dialog_->LineImpact_P, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
   connect(dialog_->borderSize_P, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
            
    connect(dialog_->activeColor1_B, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
    connect(dialog_->activeColor2_B, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
    connect(dialog_->inactiveColor1_B, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
    connect(dialog_->inactiveColor2_B, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
    connect(dialog_->buttonStyle_B, TQ_SIGNAL(activated(int)), TQ_SIGNAL(changed()));
    connect(dialog_->shapeUL_B, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->shapeUR_B, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->shapeLL_B, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->shapeLR_B, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->drawIcon_B, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
    connect(dialog_->titleeffect_B, TQ_SIGNAL(activated(int)),  TQ_SIGNAL(changed()));
    connect(dialog_->i_titleeffect_B, TQ_SIGNAL(activated(int)), TQ_SIGNAL(changed()));
    connect(dialog_->_3DImpact_B, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
    connect(dialog_->LineImpact_B, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
   connect(dialog_->borderSize_B, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
   
   connect(dialog_->activeColor1_T, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
   connect(dialog_->activeColor2_T, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));            
   connect(dialog_->buttonStyle_T, TQ_SIGNAL(activated(int)), TQ_SIGNAL(changed()));
   connect(dialog_->shapeUL_T, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
   connect(dialog_->shapeUR_T, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
   connect(dialog_->shapeLL_T, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
   connect(dialog_->shapeLR_T, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
   connect(dialog_->drawIcon_T, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));    
   connect(dialog_->_3DImpact_T, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
   connect(dialog_->borderSize_T, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
   
   connect(dialog_->activeColor1_S, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
   connect(dialog_->activeColor2_S, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
   connect(dialog_->inactiveColor1_S, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
   connect(dialog_->inactiveColor2_S, TQ_SIGNAL(clicked()), TQ_SIGNAL(changed()));
   connect(dialog_->buttonStyle_S, TQ_SIGNAL(activated(int)), TQ_SIGNAL(changed()));
   connect(dialog_->shapeUL_S, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
   connect(dialog_->shapeUR_S, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
   connect(dialog_->shapeLL_S, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
   connect(dialog_->shapeLR_S, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
   connect(dialog_->drawIcon_S, TQ_SIGNAL(toggled(bool)), TQ_SIGNAL(changed()));
   connect(dialog_->titleeffect_S, TQ_SIGNAL(activated(int)),  TQ_SIGNAL(changed()));
   connect(dialog_->i_titleeffect_S, TQ_SIGNAL(activated(int)), TQ_SIGNAL(changed()));
   connect(dialog_->_3DImpact_S, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
   connect(dialog_->LineImpact_S, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
   connect(dialog_->borderSize_S, TQ_SIGNAL(valueChanged(int)), TQ_SIGNAL(changed()));
//     config_->endGroup();

}

//////////////////////////////////////////////////////////////////////////////
// ~BaghiraConfig()
// --------------
// Destructor

BaghiraConfig::~BaghiraConfig()
{
    if (dialog_) delete dialog_;
//     if (config_) delete config_;
}

//////////////////////////////////////////////////////////////////////////////
// load()
// ------
// Load configuration data

void BaghiraConfig::load(TDEConfig*)
{
    TQSettings *config_ = new TQSettings;
    config_->beginGroup("/baghira/Deco");
    
    TQString value = config_->readEntry("TitleAlignment", "AlignHCenter");
    TQRadioButton *button = (TQRadioButton*)dialog_->titlealign->
        child((const char *)value.latin1());
    if (button) button->setChecked(true);

    dialog_->minTH->setValue(config_->readNumEntry("minimumTitleHeight",18));
    dialog_->ResizeGrip->setChecked(config_->readBoolEntry("ResizeGrip",false));
    dialog_->allowEasyClosing->setChecked(config_->readBoolEntry("allowEasyClosing",false));
    dialog_->drawComicFrame->setChecked(config_->readBoolEntry("DrawComicFrame",false));
    dialog_->maxResizable->setChecked(config_->readBoolEntry("MaxResizable",false));
    dialog_->fullSpec->setChecked(config_->readBoolEntry("FullSpec",false));
    dialog_->addAutoSpacing->setChecked(config_->readBoolEntry("AddAutoSpacing",true));
    dialog_->defaultMode->setCurrentItem(config_->readNumEntry("defaultMode",1));
    dialog_->noModalDeco->setChecked(config_->readBoolEntry("NoModalDeco",false));
    dialog_->delAppname->setChecked(config_->readBoolEntry("RemoveAppname",false));
        
    dialog_->activeColor1_J->setColor(TQColor((unsigned int)config_->readNumEntry("activeColor1_1",TQColor(255,255,255).rgb())));
    dialog_->inactiveColor1_J->setColor(TQColor((unsigned int)config_->readNumEntry("inactiveColor1_1",TQColor(204,214,230).rgb())));
   dialog_->activeColor2_J->setColor(TQColor((unsigned int)config_->readNumEntry("activeColor2_1",TQColor(238,234,238).rgb())));
    dialog_->inactiveColor2_J->setColor(TQColor((unsigned int)config_->readNumEntry("inactiveColor2_1",TQColor(194,196,211).rgb())));
    dialog_->buttonStyle_J->setCurrentItem(config_->readNumEntry("ButtonStyle_1",1));
    dialog_->titleeffect_J->setCurrentItem(config_->readNumEntry("TitleEffect_1", 1));
    dialog_->i_titleeffect_J->setCurrentItem(config_->readNumEntry("inactiveTitleEffect_1", 1));
    dialog_->shapeUL_J->setChecked(config_->readBoolEntry("ShapeUL_1",true));
    dialog_->shapeUR_J->setChecked(config_->readBoolEntry("ShapeUR_1",true));
    dialog_->shapeLL_J->setChecked(config_->readBoolEntry("ShapeLL_1",false));
    dialog_->shapeLR_J->setChecked(config_->readBoolEntry("ShapeLR_1",false));
    dialog_->drawIcon_J->setChecked(config_->readBoolEntry("drawIcon_1",true));
    dialog_->_3DImpact_J->setValue(config_->readNumEntry("3DImpact_1",20));
    dialog_->LineImpact_J->setValue(config_->readNumEntry("LineImpact_1",40));
   dialog_->borderSize_J->setValue(config_->readNumEntry("BorderSize_1",0));
    
    dialog_->activeColor1_P->setColor(TQColor((unsigned int)config_->readNumEntry("activeColor1_2",TQColor(238,238,238).rgb())));
    dialog_->inactiveColor1_P->setColor(TQColor((unsigned int)config_->readNumEntry("inactiveColor1_2",TQColor(246,242,246).rgb())));
    dialog_->activeColor2_P->setColor(TQColor((unsigned int)config_->readNumEntry("activeColor2_2",TQColor(205,202,205).rgb())));
    dialog_->inactiveColor2_P->setColor(TQColor((unsigned int)config_->readNumEntry("inactiveColor2_2",TQColor(238,238,238).rgb())));
    dialog_->buttonStyle_P->setCurrentItem(config_->readNumEntry("ButtonStyle_2",0));
    dialog_->titleeffect_P->setCurrentItem(config_->readNumEntry("TitleEffect_2", 0));
    dialog_->i_titleeffect_P->setCurrentItem(config_->readNumEntry("inactiveTitleEffect_2", 0));
    dialog_->shapeUL_P->setChecked(config_->readBoolEntry("ShapeUL_2",true));
    dialog_->shapeUR_P->setChecked(config_->readBoolEntry("ShapeUR_2",true));
    dialog_->shapeLL_P->setChecked(config_->readBoolEntry("ShapeLL_2",false));
    dialog_->shapeLR_P->setChecked(config_->readBoolEntry("ShapeLR_2",false));
    dialog_->drawIcon_P->setChecked(config_->readBoolEntry("drawIcon_2",true));
    dialog_->_3DImpact_P->setValue(config_->readNumEntry("3DImpact_2",20));
    dialog_->LineImpact_P->setValue(config_->readNumEntry("LineImpact_2",40));
   dialog_->borderSize_P->setValue(config_->readNumEntry("BorderSize_2",0));
    
    dialog_->activeColor1_B->setColor(TQColor((unsigned int)config_->readNumEntry("activeColor1_3",TQColor(202,202,202).rgb())));
    dialog_->inactiveColor1_B->setColor(TQColor((unsigned int)config_->readNumEntry("inactiveColor1_3",TQColor(200,200,200).rgb())));
    dialog_->activeColor2_B->setColor(TQColor((unsigned int)config_->readNumEntry("activeColor2_3",TQColor(150,150,150).rgb())));
   dialog_->inactiveColor2_B->setColor(TQColor((unsigned int)config_->readNumEntry("inactiveColor2_3",TQColor(150,150,150).rgb())));
    dialog_->buttonStyle_B->setCurrentItem(config_->readNumEntry("ButtonStyle_3",0));
    dialog_->titleeffect_B->setCurrentItem(config_->readNumEntry("TitleEffect_3", 4));
    dialog_->i_titleeffect_B->setCurrentItem(config_->readNumEntry("inactiveTitleEffect_3", 4));
    dialog_->shapeUL_B->setChecked(config_->readBoolEntry("ShapeUL_3",true));
    dialog_->shapeUR_B->setChecked(config_->readBoolEntry("ShapeUR_3",true));
    dialog_->shapeLL_B->setChecked(config_->readBoolEntry("ShapeLL_3",true));
    dialog_->shapeLR_B->setChecked(config_->readBoolEntry("ShapeLR_3",true));
    dialog_->drawIcon_B->setChecked(config_->readBoolEntry("drawIcon_3",true));
    dialog_->_3DImpact_B->setValue(config_->readNumEntry("3DImpact_3",20));
    dialog_->LineImpact_B->setValue(config_->readNumEntry("LineImpact_3",0));
   dialog_->borderSize_B->setValue(config_->readNumEntry("BorderSize_3",6));
   
   dialog_->activeColor1_T->setColor(TQColor((unsigned int)config_->readNumEntry("activeColor1_4",TQColor(238,238,238).rgb())));
   dialog_->activeColor2_T->setColor(TQColor((unsigned int)config_->readNumEntry("activeColor2_4",TQColor(205,202,205).rgb())));
   dialog_->buttonStyle_T->setCurrentItem(config_->readNumEntry("ButtonStyle_4",0));
   dialog_->shapeUL_T->setChecked(config_->readBoolEntry("ShapeUL_4",true));
   dialog_->shapeUR_T->setChecked(config_->readBoolEntry("ShapeUR_4",true));
   dialog_->shapeLL_T->setChecked(config_->readBoolEntry("ShapeLL_4",false));
   dialog_->shapeLR_T->setChecked(config_->readBoolEntry("ShapeLR_4",false));
   dialog_->drawIcon_T->setChecked(config_->readBoolEntry("drawIcon_4",true));
   dialog_->_3DImpact_T->setValue(config_->readNumEntry("3DImpact_4",20));
   dialog_->borderSize_T->setValue(config_->readNumEntry("BorderSize_4",0));
   
   dialog_->activeColor1_S->setColor(TQColor((unsigned int)config_->readNumEntry("activeColor1_5",TQColor(250,250,250).rgb())));
   dialog_->inactiveColor1_S->setColor(TQColor((unsigned int)config_->readNumEntry("inactiveColor1_5",TQColor(230,230,230).rgb())));
   dialog_->activeColor2_S->setColor(TQColor((unsigned int)config_->readNumEntry("activeColor2_5",TQColor(230,230,230).rgb())));
   dialog_->inactiveColor2_S->setColor(TQColor((unsigned int)config_->readNumEntry("inactiveColor2_5",TQColor(250,250,250).rgb())));
   dialog_->buttonStyle_S->setCurrentItem(config_->readNumEntry("ButtonStyle_5",0));
   dialog_->titleeffect_S->setCurrentItem(config_->readNumEntry("TitleEffect_5", 0));
   dialog_->i_titleeffect_S->setCurrentItem(config_->readNumEntry("inactiveTitleEffect_5", 0));
   dialog_->shapeUL_S->setChecked(config_->readBoolEntry("ShapeUL_5",true));
   dialog_->shapeUR_S->setChecked(config_->readBoolEntry("ShapeUR_5",true));
   dialog_->shapeLL_S->setChecked(config_->readBoolEntry("ShapeLL_5",false));
   dialog_->shapeLR_S->setChecked(config_->readBoolEntry("ShapeLR_5",false));
   dialog_->drawIcon_S->setChecked(config_->readBoolEntry("drawIcon_5",true));
   dialog_->_3DImpact_S->setValue(config_->readNumEntry("3DImpact_5",20));
   dialog_->LineImpact_S->setValue(config_->readNumEntry("LineImpact_5",30));
   dialog_->borderSize_S->setValue(config_->readNumEntry("BorderSize_5",0));
   
    buttonDialog_->inactiveColor->setColor(TQColor((unsigned int)config_->readNumEntry("InactiveButtonColor", TQColor(255,255,255).rgb())));
    buttonDialog_->closeColor->setColor(TQColor((unsigned int)config_->readNumEntry("CloseButtonColor", TQColor(200,85,70).rgb())));
    buttonDialog_->minColor->setColor(TQColor((unsigned int)config_->readNumEntry("MinButtonColor", TQColor(230,155,40).rgb())));
    buttonDialog_->         maxColor->setColor(TQColor((unsigned int)config_->readNumEntry("MaxButtonColor", TQColor(121,180,54).rgb())));
    buttonDialog_->menuColor->setColor(TQColor((unsigned int)config_->readNumEntry("MenuButtonColor", TQColor(74,140,242).rgb())));
    buttonDialog_->helpColor->setColor(TQColor((unsigned int)config_->readNumEntry("HelpButtonColor", TQColor(0,0,0).rgb())));
    buttonDialog_->stickyColor->setColor(TQColor((unsigned int)config_->readNumEntry("StickyButtonColor", TQColor(74,140,242).rgb())));
    buttonDialog_->aboveColor->setColor(TQColor((unsigned int)config_->readNumEntry("AboveButtonColor", TQColor(74,140,242).rgb())));
    buttonDialog_->behindColor->setColor(TQColor((unsigned int)config_->readNumEntry("BehindButtonColor", TQColor(74,140,242).rgb())));
    buttonDialog_->shadeColor->setColor(TQColor((unsigned int)config_->readNumEntry("ShadeButtonColor", TQColor(74,140,242).rgb())));
    buttonDialog_->init();
    config_->endGroup();
    delete config_;

}

//////////////////////////////////////////////////////////////////////////////
// save()
// ------
// Save configuration data

void BaghiraConfig::save(TDEConfig*)
{
    TQSettings *config_ = new TQSettings;
    config_->beginGroup("/baghira/Deco");

    TQRadioButton *button = (TQRadioButton*)dialog_->titlealign->selected();
    if (button) config_->writeEntry("TitleAlignment", TQString(button->name()));
    config_->writeEntry("DrawComicFrame", dialog_->drawComicFrame->isChecked());
    config_->writeEntry("AddAutoSpacing", dialog_->addAutoSpacing->isChecked());
    config_->writeEntry("ResizeGrip", dialog_->ResizeGrip->isChecked());
    config_->writeEntry("allowEasyClosing", dialog_->allowEasyClosing->isChecked());
    config_->writeEntry("MaxResizable", dialog_->maxResizable->isChecked());
    config_->writeEntry("FullSpec", dialog_->fullSpec->isChecked());
    config_->writeEntry("defaultMode", dialog_->defaultMode->currentItem());
    config_->writeEntry("minimumTitleHeight", dialog_->minTH->value());
    config_->writeEntry("NoModalDeco", dialog_->noModalDeco->isChecked());
    config_->writeEntry("RemoveAppname", dialog_->delAppname->isChecked());
       
    config_->writeEntry("activeColor1_1", (int)dialog_->activeColor1_J->color().rgb());
    config_->writeEntry("activeColor2_1", (int)dialog_->activeColor2_J->color().rgb());
    config_->writeEntry("inactiveColor1_1", (int)dialog_->inactiveColor1_J->color().rgb());
    config_->writeEntry("inactiveColor2_1", (int)dialog_->inactiveColor2_J->color().rgb());
    config_->writeEntry("ButtonStyle_1", dialog_->buttonStyle_J->currentItem());
    config_->writeEntry("TitleEffect_1", dialog_->titleeffect_J->currentItem());
    config_->writeEntry("inactiveTitleEffect_1", dialog_->i_titleeffect_J->currentItem());
    config_->writeEntry("ShapeUL_1", dialog_->shapeUL_J->isChecked());
    config_->writeEntry("ShapeUR_1", dialog_->shapeUR_J->isChecked());
    config_->writeEntry("ShapeLL_1", dialog_->shapeLL_J->isChecked());
    config_->writeEntry("ShapeLR_1", dialog_->shapeLR_J->isChecked());    
    config_->writeEntry("drawIcon_1", dialog_->drawIcon_J->isChecked());
    config_->writeEntry("3DImpact_1", dialog_->_3DImpact_J->value());
    config_->writeEntry("LineImpact_1", dialog_->LineImpact_J->value());
   config_->writeEntry("BorderSize_1", dialog_->borderSize_J->value());
    
    config_->writeEntry("activeColor1_2", (int)dialog_->activeColor1_P->color().rgb());
    config_->writeEntry("activeColor2_2", (int)dialog_->activeColor2_P->color().rgb());
    config_->writeEntry("inactiveColor1_2", (int)dialog_->inactiveColor1_P->color().rgb());
    config_->writeEntry("inactiveColor2_2", (int)dialog_->inactiveColor2_P->color().rgb());
    config_->writeEntry("ButtonStyle_2", dialog_->buttonStyle_P->currentItem());
    config_->writeEntry("TitleEffect_2", dialog_->titleeffect_P->currentItem());
    config_->writeEntry("inactiveTitleEffect_2", dialog_->i_titleeffect_P->currentItem());
    config_->writeEntry("ShapeUL_2", dialog_->shapeUL_P->isChecked());
    config_->writeEntry("ShapeUR_2", dialog_->shapeUR_P->isChecked());
    config_->writeEntry("ShapeLL_2", dialog_->shapeLL_P->isChecked());
    config_->writeEntry("ShapeLR_2", dialog_->shapeLR_P->isChecked());    
    config_->writeEntry("drawIcon_2", dialog_->drawIcon_P->isChecked());
    config_->writeEntry("3DImpact_2", dialog_->_3DImpact_P->value());
    config_->writeEntry("LineImpact_2", dialog_->LineImpact_P->value());
   config_->writeEntry("BorderSize_2", dialog_->borderSize_P->value());
    
    config_->writeEntry("activeColor1_3", (int)dialog_->activeColor1_B->color().rgb());
    config_->writeEntry("activeColor2_3", (int)dialog_->activeColor2_B->color().rgb());
    config_->writeEntry("inactiveColor1_3", (int)dialog_->inactiveColor1_B->color().rgb());
    config_->writeEntry("inactiveColor2_3", (int)dialog_->inactiveColor2_B->color().rgb());
    config_->writeEntry("ButtonStyle_3", dialog_->buttonStyle_B->currentItem());
    config_->writeEntry("TitleEffect_3", dialog_->titleeffect_B->currentItem());
    config_->writeEntry("inactiveTitleEffect_3", dialog_->i_titleeffect_B->currentItem());
    config_->writeEntry("ShapeUL_3", dialog_->shapeUL_B->isChecked());
    config_->writeEntry("ShapeUR_3", dialog_->shapeUR_B->isChecked());
    config_->writeEntry("ShapeLL_3", dialog_->shapeLL_B->isChecked());
    config_->writeEntry("ShapeLR_3", dialog_->shapeLR_B->isChecked());    
    config_->writeEntry("drawIcon_3", dialog_->drawIcon_B->isChecked());
    config_->writeEntry("3DImpact_3", dialog_->_3DImpact_B->value());
    config_->writeEntry("LineImpact_3", dialog_->LineImpact_B->value());
   config_->writeEntry("BorderSize_3", dialog_->borderSize_B->value());
   
   config_->writeEntry("activeColor1_4", (int)dialog_->activeColor1_T->color().rgb());
   config_->writeEntry("activeColor2_4", (int)dialog_->activeColor2_T->color().rgb());
   config_->writeEntry("ButtonStyle_4", dialog_->buttonStyle_T->currentItem());
   config_->writeEntry("ShapeUL_4", dialog_->shapeUL_T->isChecked());
   config_->writeEntry("ShapeUR_4", dialog_->shapeUR_T->isChecked());
   config_->writeEntry("ShapeLL_4", dialog_->shapeLL_T->isChecked());
   config_->writeEntry("ShapeLR_4", dialog_->shapeLR_T->isChecked());    
   config_->writeEntry("drawIcon_4", dialog_->drawIcon_T->isChecked());
   config_->writeEntry("3DImpact_4", dialog_->_3DImpact_T->value());
   config_->writeEntry("BorderSize_4", dialog_->borderSize_T->value());
   
   config_->writeEntry("activeColor1_5", (int)dialog_->activeColor1_S->color().rgb());
   config_->writeEntry("activeColor2_5", (int)dialog_->activeColor2_S->color().rgb());
   config_->writeEntry("inactiveColor1_5", (int)dialog_->inactiveColor1_S->color().rgb());
   config_->writeEntry("inactiveColor2_5", (int)dialog_->inactiveColor2_S->color().rgb());
   config_->writeEntry("ButtonStyle_5", dialog_->buttonStyle_S->currentItem());
   config_->writeEntry("TitleEffect_5", dialog_->titleeffect_S->currentItem());
   config_->writeEntry("inactiveTitleEffect_5", dialog_->i_titleeffect_S->currentItem());
   config_->writeEntry("ShapeUL_5", dialog_->shapeUL_S->isChecked());
   config_->writeEntry("ShapeUR_5", dialog_->shapeUR_S->isChecked());
   config_->writeEntry("ShapeLL_5", dialog_->shapeLL_S->isChecked());
   config_->writeEntry("ShapeLR_5", dialog_->shapeLR_S->isChecked());    
   config_->writeEntry("drawIcon_5", dialog_->drawIcon_S->isChecked());
   config_->writeEntry("3DImpact_5", dialog_->_3DImpact_S->value());
   config_->writeEntry("LineImpact_5", dialog_->LineImpact_S->value());
   config_->writeEntry("BorderSize_5", dialog_->borderSize_S->value());
    
    if (buttonDialog_->save){
    config_->writeEntry("InactiveButtonColor", (int)buttonDialog_->inactiveColor->Color().rgb());
    config_->writeEntry("CloseButtonColor", (int)buttonDialog_->closeColor->Color().rgb());
    config_->writeEntry("MinButtonColor", (int)buttonDialog_->minColor->Color().rgb());
    config_->writeEntry("MaxButtonColor", (int)buttonDialog_->maxColor->Color().rgb());
    config_->writeEntry("MenuButtonColor", (int)buttonDialog_->menuColor->Color().rgb());
    config_->writeEntry("HelpButtonColor", (int)buttonDialog_->helpColor->Color().rgb());
    config_->writeEntry("StickyButtonColor", (int)buttonDialog_->stickyColor->Color().rgb());
    config_->writeEntry("AboveButtonColor", (int)buttonDialog_->aboveColor->Color().rgb());
    config_->writeEntry("BehindButtonColor", (int)buttonDialog_->behindColor->Color().rgb());
    config_->writeEntry("ShadeButtonColor", (int)buttonDialog_->shadeColor->Color().rgb());
    }
    config_->endGroup();
    delete config_;
        
//     config_->sync();
}

//////////////////////////////////////////////////////////////////////////////
// defaults()
// ----------
// Set configuration defaults

void BaghiraConfig::defaults()
{
    TQRadioButton *button = (TQRadioButton*)dialog_->titlealign->child("AlignHCenter");
    if (button) button->setChecked(true);
    dialog_->allowEasyClosing->setChecked(false);
    dialog_->minTH->setValue(22);
    dialog_->ResizeGrip->setChecked(false);
    dialog_->drawComicFrame->setChecked(false);
    dialog_->addAutoSpacing->setChecked(true);
    dialog_->maxResizable->setChecked(false);
    dialog_->fullSpec->setChecked(false);
    dialog_->defaultMode->setCurrentItem(1);
   dialog_->noModalDeco->setChecked(false);
   dialog_->delAppname->setChecked(false);

   dialog_->activeColor1_J->setColor(TQColor(255,255,255));
   dialog_->inactiveColor1_J->setColor(TQColor(204,214,230));
   dialog_->activeColor2_J->setColor(TQColor(238,234,238));
   dialog_->inactiveColor2_J->setColor(TQColor(194,196,211));
   dialog_->buttonStyle_J->setCurrentItem(1);
   dialog_->titleeffect_J->setCurrentItem(1);
   dialog_->i_titleeffect_J->setCurrentItem(1);
   dialog_->shapeUL_J->setChecked(true);
   dialog_->shapeUR_J->setChecked(true);
   dialog_->shapeLL_J->setChecked(false);
   dialog_->shapeLR_J->setChecked(false);
   dialog_->drawIcon_J->setChecked(true);
   dialog_->_3DImpact_J->setValue(20);
   dialog_->LineImpact_J->setValue(40);
   dialog_->borderSize_J->setValue(0);
   
   dialog_->activeColor1_P->setColor(TQColor(238,238,238));
   dialog_->inactiveColor1_P->setColor(TQColor(246,242,246));
   dialog_->activeColor2_P->setColor(TQColor(205,202,205));
   dialog_->inactiveColor2_P->setColor(TQColor(238,238,238));
   dialog_->buttonStyle_P->setCurrentItem(0);
   dialog_->titleeffect_P->setCurrentItem(0);
   dialog_->i_titleeffect_P->setCurrentItem(0);
   dialog_->shapeUL_P->setChecked(true);
   dialog_->shapeUR_P->setChecked(true);
   dialog_->shapeLL_P->setChecked(false);
   dialog_->shapeLR_P->setChecked(false);
   dialog_->drawIcon_P->setChecked(true);
   dialog_->_3DImpact_P->setValue(20);
   dialog_->LineImpact_P->setValue(30);
   dialog_->borderSize_P->setValue(0);
   
   dialog_->activeColor1_B->setColor(TQColor(210,210,210));
   dialog_->inactiveColor1_B->setColor(TQColor(200,200,200));
   dialog_->activeColor2_B->setColor(TQColor(150,150,150));
   dialog_->inactiveColor2_B->setColor(TQColor(140,140,140));
   dialog_->buttonStyle_B->setCurrentItem(0);
   dialog_->titleeffect_B->setCurrentItem(4);
   dialog_->i_titleeffect_B->setCurrentItem(4);
   dialog_->shapeUL_B->setChecked(true);
   dialog_->shapeUR_B->setChecked(true);
   dialog_->shapeLL_B->setChecked(false);
   dialog_->shapeLR_B->setChecked(false);
   dialog_->drawIcon_B->setChecked(true);
   dialog_->_3DImpact_B->setValue(20);
   dialog_->LineImpact_B->setValue(0);
   dialog_->borderSize_B->setValue(6);
   
   dialog_->activeColor1_T->setColor(TQColor(238,238,238));
   dialog_->activeColor2_T->setColor(TQColor(211,208,211));
   dialog_->buttonStyle_T->setCurrentItem(0);
   dialog_->shapeUL_T->setChecked(true);
   dialog_->shapeUR_T->setChecked(true);
   dialog_->shapeLL_T->setChecked(false);
   dialog_->shapeLR_T->setChecked(false);
   dialog_->drawIcon_T->setChecked(true);
   dialog_->_3DImpact_T->setValue(20);
   dialog_->borderSize_T->setValue(0);
   
   dialog_->activeColor1_S->setColor(TQColor(250,250,250));
   dialog_->inactiveColor1_S->setColor(TQColor(230,230,230));
   dialog_->activeColor2_S->setColor(TQColor(230,230,230));
   dialog_->inactiveColor2_S->setColor(TQColor(250,250,250));
   dialog_->buttonStyle_S->setCurrentItem(0);
   dialog_->titleeffect_S->setCurrentItem(0);
   dialog_->i_titleeffect_S->setCurrentItem(0);
   dialog_->shapeUL_S->setChecked(true);
   dialog_->shapeUR_S->setChecked(true);
   dialog_->shapeLL_S->setChecked(false);
   dialog_->shapeLR_S->setChecked(false);
   dialog_->drawIcon_S->setChecked(true);
   dialog_->_3DImpact_S->setValue(20);
   dialog_->LineImpact_S->setValue(30);
   dialog_->borderSize_S->setValue(0);
   
//   buttonDialog_->defaults();

    
}   

enum ColorPresets{Aqua = 0, Graphite, GraphiteDark, NUMBEROFCOLORS};

const char * presetColorName[NUMBEROFCOLORS] = {"Aqua", "Graphite", "Graphite (Dark)" };

typedef int ColorTable[10][3];

const int aquaPreset[10][3] = {{255,255,255},{200,85,70},{230,155,40},{121,180,54},{74,140,242},{0,0,0},{74,140,242},{74,140,242},{74,140,242},{74,140,242}};
const int graphitePreset[10][3] = {{255,255,255},{130,170,190},{130,170,190},{130,170,190},{130,170,190},{0,0,0},{130,170,190},{130,170,190},{130,170,190},{130,170,190}};
const int graphiteDarkPreset[10][3] = {{255,255,255},{103,118,134},{103,118,134},{103,118,134},{103,118,134},{0,0,0},{103,118,134},{103,118,134},{103,118,134},{103,118,134}};
const ColorTable* presetColors[NUMBEROFCOLORS] = {&aquaPreset, &graphitePreset, &graphiteDarkPreset};


ButtonColors::ButtonColors(TQWidget *parent, const char * name) : TQDialog(parent, name){
    save = false;
    layout = new TQGridLayout(this,2,2,11,6, "Grid");
    buttonLayout = new TQVBoxLayout(0,0,6);
    
    TQPixmap tmpPix = TQPixmap(uic_findImage("preview"));
    inactiveButton = new AquariusButton(tmpPix,this, "Inactive Button");
    buttonLayout->addWidget(inactiveButton);
    closeButton = new AquariusButton(tmpPix,this, "Close Button");
    buttonLayout->addWidget(closeButton);
    minButton = new AquariusButton(tmpPix,this, "Minimize Button");
    buttonLayout->addWidget(minButton);
    maxButton = new AquariusButton(tmpPix,this, "Maximize Button");
    buttonLayout->addWidget(maxButton);
    stickyButton = new AquariusButton(tmpPix,this, "Sticky Button");
    buttonLayout->addWidget(stickyButton);
    aboveButton = new AquariusButton(tmpPix,this, "Above Button");
    buttonLayout->addWidget(aboveButton);
    behindButton = new AquariusButton(tmpPix,this, "Behind Button");
    buttonLayout->addWidget(behindButton);
    shadeButton = new AquariusButton(tmpPix,this, "Shade Button");
    buttonLayout->addWidget(shadeButton);
    tmpPix = TQPixmap(uic_findImage("preview-menu"));
    menuButton = new AquariusButton(tmpPix,this, "Menu Button");
    buttonLayout->addWidget(menuButton);
    tmpPix = TQPixmap(uic_findImage("icon_help"));
    helpButton = new AquariusButton(tmpPix,this, "Help Button");
    buttonLayout->addWidget(helpButton);
    
    
    twoButts = new TQHBoxLayout(0,0,6);
    presets_ = new TQComboBox(this);
    for (int i = 0; i < NUMBEROFCOLORS; i++)
        presets_->insertItem ( presetColorName[i], i );
    twoButts->addWidget(presets_);
    cancel = new TQPushButton("Cancel", this);
    cancel->setDefault( true );
    twoButts->addWidget(cancel);
    twoButts->addStretch();
    layout->addLayout(twoButts,1,0);
    ok = new TQPushButton("OK", this);
    layout->addWidget(ok,1,1);
    
    layout->addLayout(buttonLayout,0,1);
    
    pickerLayout = new TQVBoxLayout(0,0,6,0);
    
    indicator = new TQLabel(inactiveButton->name(), this);
    indicator->setAlignment(TQt::AlignHCenter | TQt::AlignVCenter | TQt::ExpandTabs);
    TQFont tmpFont = font();
    tmpFont.setBold( true );
    tmpFont.setPointSize( 24 );
    indicator->setFont(tmpFont);
    pickerLayout->addWidget(indicator);
    
    inactiveColor = new ColorPicker(this);
    pickerLayout->addWidget(inactiveColor);
    currentPicker = inactiveColor;
    closeColor = new ColorPicker(this);
    pickerLayout->addWidget(closeColor);
    closeColor->hide();
    minColor = new ColorPicker(this);
    pickerLayout->addWidget(minColor);
    minColor->hide();
    maxColor = new ColorPicker(this);
    pickerLayout->addWidget(maxColor);
    maxColor->hide();
    menuColor = new ColorPicker(this);
    pickerLayout->addWidget(menuColor);
    menuColor->hide();
    helpColor = new ColorPicker(this);
    pickerLayout->addWidget(helpColor);
    helpColor->hide();
    stickyColor = new ColorPicker(this);
    pickerLayout->addWidget(stickyColor);
    stickyColor->hide();
    aboveColor = new ColorPicker(this);
    pickerLayout->addWidget(aboveColor);
    aboveColor->hide();
    behindColor = new ColorPicker(this);
    pickerLayout->addWidget(behindColor);
    behindColor->hide();
    shadeColor = new ColorPicker(this);
    pickerLayout->addWidget(shadeColor);
    shadeColor->hide();
    
    indicator->lower();
    
    layout->addLayout(pickerLayout,0,0);
    
    resize( TQSize(485, 177).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
    
    connect(presets_,TQ_SIGNAL(activated(int)), this, TQ_SLOT(setColorGroup(int)));
    connect(ok, TQ_SIGNAL(clicked()), this, TQ_SLOT(setSave()));
    connect(ok, TQ_SIGNAL(clicked()), this, TQ_SLOT(close()) );
    connect(ok, TQ_SIGNAL(clicked()), this, TQ_SLOT(init()) );
    connect(cancel, TQ_SIGNAL(clicked()), this, TQ_SLOT(close()) );
    connect(cancel, TQ_SIGNAL(clicked()), this, TQ_SLOT(reset()) );
    
    connect(inactiveButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(activateInactive()) );
    connect(closeButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(activateClose()) );
    connect(minButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(activateMin()) );
    connect(maxButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(activateMax()) );
    connect(menuButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(activateMenu()) );
    connect(helpButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(activateHelp()) );
    connect(stickyButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(activateSticky()) );
    connect(aboveButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(activateAbove()) );
    connect(behindButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(activateBehind()) );
    connect(shadeButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(activateShade()) );
    
    connect(inactiveColor, TQ_SIGNAL(colorChanged(TQColor)), inactiveButton, TQ_SLOT(setColor(TQColor)) );
    connect(closeColor, TQ_SIGNAL(colorChanged(TQColor)), closeButton, TQ_SLOT(setColor(TQColor)) );
    connect(minColor, TQ_SIGNAL(colorChanged(TQColor)), minButton, TQ_SLOT(setColor(TQColor)) );
    connect(maxColor, TQ_SIGNAL(colorChanged(TQColor)), maxButton, TQ_SLOT(setColor(TQColor)) );
    connect(menuColor, TQ_SIGNAL(colorChanged(TQColor)), menuButton, TQ_SLOT(setColor(TQColor)) );
    connect(helpColor, TQ_SIGNAL(colorChanged(TQColor)), helpButton, TQ_SLOT(setColor(TQColor)) );
    connect(stickyColor, TQ_SIGNAL(colorChanged(TQColor)), stickyButton, TQ_SLOT(setColor(TQColor)) );
    connect(aboveColor, TQ_SIGNAL(colorChanged(TQColor)), aboveButton, TQ_SLOT(setColor(TQColor)) );
    connect(behindColor, TQ_SIGNAL(colorChanged(TQColor)), behindButton, TQ_SLOT(setColor(TQColor)) );
    connect(shadeColor, TQ_SIGNAL(colorChanged(TQColor)), shadeButton, TQ_SLOT(setColor(TQColor)) );

}

ButtonColors::~ButtonColors(){
}

void ButtonColors::setColorGroup(int i){
    inactiveColor->setColor(TQColor((*presetColors[i])[0][0],(*presetColors[i])[0][1],(*presetColors[i])[0][2]).rgb());
    closeColor->setColor(TQColor((*presetColors[i])[1][0],(*presetColors[i])[1][1],(*presetColors[i])[1][2]).rgb());
    minColor->setColor(TQColor((*presetColors[i])[2][0],(*presetColors[i])[2][1],(*presetColors[i])[2][2]).rgb());
    maxColor->setColor(TQColor((*presetColors[i])[3][0],(*presetColors[i])[3][1],(*presetColors[i])[3][2]).rgb());
    menuColor->setColor(TQColor((*presetColors[i])[4][0],(*presetColors[i])[4][1],(*presetColors[i])[4][2]).rgb());
    helpColor->setColor(TQColor((*presetColors[i])[5][0],(*presetColors[i])[5][1],(*presetColors[i])[5][2]).rgb());
    stickyColor->setColor(TQColor((*presetColors[i])[6][0],(*presetColors[i])[6][1],(*presetColors[i])[6][2]).rgb());
    aboveColor->setColor(TQColor((*presetColors[i])[7][0],(*presetColors[i])[7][1],(*presetColors[i])[7][2]).rgb());
    behindColor->setColor(TQColor((*presetColors[i])[8][0],(*presetColors[i])[8][1],(*presetColors[i])[8][2]).rgb());
    shadeColor->setColor(TQColor((*presetColors[i])[9][0],(*presetColors[i])[9][1],(*presetColors[i])[9][2]).rgb());
}

void ButtonColors::setPicker(ColorPicker *picker){
    if (currentPicker) currentPicker->hide();
    currentPicker = picker;
    currentPicker->show();
}

void ButtonColors::activateInactive(){
    setPicker(inactiveColor);
    indicator->setText( inactiveButton->name() );
}
void ButtonColors::activateClose(){
    setPicker(closeColor);
    indicator->setText( closeButton->name() );
}
void ButtonColors::activateMin(){
    setPicker(minColor);
    indicator->setText( minButton->name() );
}
void ButtonColors::activateMax(){
    setPicker(maxColor);
    indicator->setText( maxButton->name() );
}
void ButtonColors::activateMenu(){
    setPicker(menuColor);
    indicator->setText( menuButton->name() );
}
void ButtonColors::activateHelp(){
    setPicker(helpColor);
    indicator->setText( helpButton->name() );
}
void ButtonColors::activateSticky(){
    setPicker(stickyColor);
    indicator->setText( stickyButton->name() );
}
void ButtonColors::activateAbove(){
    setPicker(aboveColor);
    indicator->setText( aboveButton->name() );
}
void ButtonColors::activateBehind(){
    setPicker(behindColor);
    indicator->setText( behindButton->name() );
}
void ButtonColors::activateShade(){
    setPicker(shadeColor);
    indicator->setText( shadeButton->name() );
}

void ButtonColors::reset(){
    inactiveColor->reset();
    closeColor->reset();
    minColor->reset();
    maxColor->reset();
    menuColor->reset();
    helpColor->reset();
    stickyColor->reset();
    aboveColor->reset();
    behindColor->reset();
    shadeColor->reset();
}

void ButtonColors::init(){
    inactiveColor->init();
    closeColor->init();
    minColor->init();
    maxColor->init();
    menuColor->init();
    helpColor->init();
    stickyColor->init();
    aboveColor->init();
    behindColor->init();
    shadeColor->init();
}

//////////////////////////////////////////////////////////////////////////////
// Plugin Stuff                                                             //
//////////////////////////////////////////////////////////////////////////////

extern "C"
{
    TDE_EXPORT TQObject* allocate_config(TDEConfig* config, TQWidget* parent) {
        return(new BaghiraConfig(config, parent));
    }
}

#include "baghiraconfig.moc"
