/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_INSTRUMENTPARAMETERPANEL_H_
#define _RG_INSTRUMENTPARAMETERPANEL_H_

#include <tqframe.h>
#include <vector>
#include <utility>

class TQWidget;
class TQLabel;


namespace Rosegarden
{

class RosegardenGUIDoc;
class Instrument;
class Rotary;

typedef std::pair<Rotary *, TQLabel *> RotaryPair;
typedef std::vector<std::pair<int, RotaryPair> > RotaryMap;


////////////////////////////////////////////////////////////////////////

class InstrumentParameterPanel : public TQFrame
{
    TQ_OBJECT
  
public:
    InstrumentParameterPanel(RosegardenGUIDoc *doc, TQWidget* parent);

    virtual ~InstrumentParameterPanel() {};

    virtual void setupForInstrument(Instrument*) = 0;

    void setDocument(RosegardenGUIDoc* doc);

    void showAdditionalControls(bool showThem);

signals:
    void updateAllBoxes();
        
protected:
    //--------------- Data members ---------------------------------
    TQLabel                          *m_instrumentLabel;
    Instrument          *m_selectedInstrument;
    RosegardenGUIDoc                *m_doc;
};



}

#endif
