import time, sys

from PyTQt.tqt import TQLabel, TQFrame, TQColor, TQPushButton, TQ_SIGNAL, TQButtonGroup, TQRadioButton, \
                  TQt, TQString, TQChar, TQWidget, TQTimer

from tdecore import TDEApplication
from tdeui import KEdit, KComboBox, KColorCombo, KEditListBox, TDEListBox, KLineEdit, KRestrictedLine,\
                  KSqueezedTextLabel, TDEFontChooser, KButtonBox, KColorButton, KColorCells,\
                  KColorPatch, KDualColorButton,\
                  KRootPermsIcon, KWritePermsIcon, KCharSelect, KDialog, KLed, KRootPixmap,\
                  KTabCtl, KProgress, KDatePicker, KDateTable, KGradientSelector, KHSSelector,\
                  KIntNumInput, KDoubleNumInput, KPasswordEdit, KURLLabel, KPaletteTable,\
                  KSeparator

class Page1:
    def __init__ (self, parent):
        self.page = parent.addPage ()

        x = 10
        y = 10

        editLbl   = TQLabel ("KEdit", self.page)
        editLbl.setGeometry (x, y, 50, 20)
        editLbl.show ()

        textList = ["Now is the winter of our discontent",\
                    "made glorious summer by this sun of York;",\
                    "and all the clouds that lour'd upon our house",\
                    "in the deep bosom of the ocean buried."]

        parent.edit = KEdit (self.page)
        parent.edit.setGeometry (x, y + 20, 300, 100)
        for line in textList:
            parent.edit.insertLine (line)
        parent.edit.show ()

        y = y + 125
        searchBtn  = TQPushButton ("Search", self.page)
        replaceBtn = TQPushButton ("Replace", self.page)
        gotoBtn    = TQPushButton ("GoTo Line", self.page)

        searchBtn.setGeometry (x, y, 60, 22)
        replaceBtn.setGeometry (x + 90, y, 60, 22)
        gotoBtn.setGeometry (x + 180, y, 60, 22)

        self.page.connect (searchBtn, TQ_SIGNAL ("clicked ()"), parent.edit.search)
        self.page.connect (replaceBtn, TQ_SIGNAL ("clicked ()"), parent.edit.replace)
        self.page.connect (gotoBtn, TQ_SIGNAL ("clicked ()"), parent.edit.doGotoLine)

        searchBtn.show ()
        replaceBtn.show ()
        gotoBtn.show ()

        y = y + 35

        lineeditLbl   = TQLabel ("KLineEdit", self.page)
        lineeditLbl.setGeometry (x, y, 70, 20)
        lineeditLbl.show ()

        lineedit = KLineEdit (self.page)
        lineedit.setGeometry (x, y + 20, 100, 20)
        lineedit.show ()

        intLbl   = TQLabel ("KIntNumInput", self.page)
        intLbl.setGeometry (x + 195, y + 35, 95, 20)
        intLbl.show ()

        intNum = KIntNumInput (5, self.page)
        intNum.setGeometry (x + 195, y + 55, 175, 50)
#        intNum.setSuffix (" GB")
#        intNum.setPrefix ("hdc    ")
        intNum.setLabel ("Capacity")
        intNum.setRange (0, 10, 1, True)
        intNum.show ()

        y = y + 50

        dblLbl   = TQLabel ("KDoubleNumInput", self.page)
        dblLbl.setGeometry (x + 195, y + 80, 115, 20)
        dblLbl.show ()

        dblNum = KDoubleNumInput (2.5, self.page)
        dblNum.setGeometry (x + 195, y + 100, 175, 50)
        dblNum.setLabel ("Variable")
        dblNum.setRange (0.0, 10.0, 0.5, True)
        dblNum.show ()

        restricteditLbl   = TQLabel ("KRestrictedLine", self.page)
        restricteditLbl.setGeometry (x, y, 95, 20)
        restricteditLbl.show ()

        self.restrictlineedit = KRestrictedLine (self.page)
        self.restrictlineedit.setGeometry (x, y + 20, 100, 20)
        self.restrictlineedit.show ()

        buttons = ["Numbers Only", "Upper Case Only", "Lower Case Only"]

        n = len (buttons)

        self.validLbl = TQLabel ("", self.page)
        self.validLbl.setGeometry (x, y + 50, 250, 20)
        self.validLbl.show ()

        grp = TQButtonGroup (n, TQt.Vertical, "Select valid chars", self.page, "button grp")
        grp.setGeometry (x, y + 75, 150, 5+30*n)
        for i in range (n):
            TQRadioButton (buttons [i], grp)

        grp.connect (grp, TQ_SIGNAL ("clicked (int)"), self.restrict)

        grp.find (0).setChecked (True)
        self.restrict (0)

        grp.show ()

        self.page.show ()
        kapp = TDEApplication.kApplication ()
        kapp.processEvents ()

        y = y + 195
        sqzLbl = TQLabel ("This text is too long to fit in the label below", self.page)
        sqzLbl.setGeometry (x, y, 350, 20)
        sqzLbl.show ()

        sqzLbl1 = TQLabel ("KSqueezedTxtLabel:", self.page)
        sqzLbl1.setGeometry (x, y + 20, 120, 20)
        sqzLbl1.show ()

        squeeze = KSqueezedTextLabel ("This text is too long to fit in the label below", self.page)
        squeeze.setGeometry (x + 125, y + 20, 125, 20)
        squeeze.setBackgroundMode (TQWidget.PaletteBase)
        squeeze.show ()

    def restrict (self, which):
        r = {0: "0123456789", 1: "ABCDEFGHIJKLMNOPQRSTUVWXYZ", 2: "abcdefghijklmnopqrstuvwxyz"}
        self.restrictlineedit.setValidChars (r [which])
        self.validLbl.setText ("Valid: " + self.restrictlineedit.validChars ().latin1 ())


class Page2:
    def __init__ (self, parent):
        self.page = parent.addPage ()

        x1 = 10
        y1 = 10
        x2 = 240
        y2 = 100



        cbLbl = TQLabel ("KComboBox", self.page)
        cbLbl.setGeometry (x1, y1, 75, 20)
        cbLbl.show ()

        combo = KComboBox (self.page)
        combo.insertStrList (["One", "Two", "Three"])
        combo.setGeometry (x1, y1 + 20, 100, 25)
        combo.show ()

        ccbLbl = TQLabel ("KColorCombo", self.page)
        ccbLbl.setGeometry (x2, y1, 100, 20)
        ccbLbl.show ()

        colorCombo = KColorCombo (self.page)
        colorCombo.setGeometry (x2, y1 + 20, 100, 25)
        colorCombo.show ()

        editListBox = KEditListBox ("KEditListBox", self.page)
        editListBox.setGeometry (x1, y2, 220, 175)
        editListBox.insertStrList (["One", "Two", "Three"])
        editListBox.show ()

        lbLbl = TQLabel ("TDEListBox", self.page)
        lbLbl.setGeometry (x2, y2, 100, 20)
        lbLbl.show ()

        listBox = TDEListBox (self.page)
        listBox.setGeometry (x2, y2 + 20, 100, 100)
        listBox.insertStrList (["One", "Two", "Three"])
        listBox.show ()

class Page3:
    def __init__ (self, parent):
        self.page = parent.addPage ()

        x = 10
        y = 10

        fontLbl   = TQLabel ("TDEFontChooser", self.page)
        fontLbl.setGeometry (x, y, 95, 20)
        fontLbl.show ()

        fontChoose = TDEFontChooser (self.page)
        fontChoose.setGeometry (x, y + 20, 375, 300)
        fontChoose.show ()

        y = y + 330

class Page4:
    def __init__ (self, parent):
        self.page = parent.addPage ()

        x = 10
        y = 10

        cbLbl   = TQLabel ("KColorButton", self.page)
        cbLbl.setGeometry (x, y, 75, 20)
        cbLbl.show ()

        cb = KColorButton (self.page)
        cb.setColor (TQColor (255, 0, 0))
        cb.setGeometry (x, y + 20, 30, 30)
        cb.show ()

        ccbLbl = TQLabel ("KColorCombo", self.page)
        ccbLbl.setGeometry (x + 150, y, 100, 20)
        ccbLbl.show ()

        colorCombo = KColorCombo (self.page)
        colorCombo.setGeometry (x + 150, y + 20, 100, 25)
        colorCombo.show ()

        y = y + 60

        cpLbl   = TQLabel ("KColorPatch", self.page)
        cpLbl.setGeometry (x, y, 75, 20)
        cpLbl.show ()

        cp = KColorPatch (self.page)
        cp.setColor (TQColor (255, 0, 0))
        cp.setGeometry (x, y + 20, 20, 20)
        cp.show ()

        x = x + 150

        ccLbl   = TQLabel ("KColorCells", self.page)
        ccLbl.setGeometry (x, y, 75, 20)
        ccLbl.show ()

        cc = KColorCells (self.page, 1, 5)
        cc.setColor (0, TQColor (0, 0, 0))
        cc.setColor (1, TQColor (255, 0, 0))
        cc.setColor (2, TQColor (0, 255, 0))
        cc.setColor (3, TQColor (0, 0, 255))
        cc.setColor (4, TQColor (255, 255, 255))
        cc.setGeometry (x, y + 20, 100, 20)
        cc.show ()

        x = 10
        y = y + 50

        dcLbl   = TQLabel ("KDualColorButton", self.page)
        dcLbl.setGeometry (x, y, 105, 20)
        dcLbl.show ()

        dc = KDualColorButton (TQColor (255, 0, 0), TQColor (0, 0, 0), self.page)
        dc.setGeometry (x, y + 20, 40, 40)
        dc.show ()

        gsLbl   = TQLabel ("KGradientSelector", self.page)
        gsLbl.setGeometry (x + 80, y + 30, 110, 20)
        gsLbl.show ()

        gs = KGradientSelector (self.page)
        gs.setGeometry (x + 80, y + 50, 250, 20)
        gs.setColors (TQColor (255, 0, 0), TQColor (255, 255, 0))
        gs.show ()

        y = y + 80

        hsLbl   = TQLabel ("KHSSelector", self.page)
        hsLbl.setGeometry (x, y, 95, 20)
        hsLbl.show ()

        hs = KHSSelector (self.page)
        hs.setGeometry (x, y + 20, 350, 80)
        hs.show ()

        y = y + 110

        ptLbl   = TQLabel ("KPaletteTable", self.page)
        ptLbl.setGeometry (x, y, 95, 20)
        ptLbl.show ()

        pt = KPaletteTable (self.page, 340, 24)
        pt.setPalette ("Royal")
        pt.setGeometry (x, y + 20, 340, 40)
        pt.show ()

class Page5:
    def __init__ (self, parent):
        self.page = parent.addPage ()

        x = 10
        y = 10

        rpLbl   = TQLabel ("KRootPermsIcon", self.page)
        rpLbl.setGeometry (x, y, 95, 20)
        rpLbl.show ()

        rp = KRootPermsIcon (self.page)
        rp.setGeometry (x, y + 20, 32, 32)
        rp.show ()

        wpLbl   = TQLabel ("KWritePermsIcon", self.page)
        wpLbl.setGeometry (x + 125, y, 95, 20)
        wpLbl.show ()

        wp = KWritePermsIcon ("/usr/bin/gcc", self.page)
        wp.setGeometry (x + 125, y + 20, 32, 32)
        wp.show ()

        y = y + 75

        pw1Lbl = TQLabel ("KPasswordEdit - echo *", self.page)
        pw1Lbl.setGeometry (x, y, 150, 20)
        pw1Lbl.show ()

        pw1 = KPasswordEdit (self.page, "", KPasswordEdit.OneStar)
        pw1.setGeometry (x, y + 20, 100, 20)
        pw1.show ()

        y = y + 50

        pw2Lbl = TQLabel ("KPasswordEdit - echo ***", self.page)
        pw2Lbl.setGeometry (x, y, 150, 20)
        pw2Lbl.show ()

        pw2 = KPasswordEdit (self.page, "", KPasswordEdit.ThreeStars)
        pw2.setGeometry (x, y + 20, 100, 20)
        pw2.show ()

        y = y + 50

        pw3Lbl = TQLabel ("KPasswordEdit - no echo", self.page)
        pw3Lbl.setGeometry (x, y, 150, 20)
        pw3Lbl.show ()

        pw3 = KPasswordEdit (self.page, "", KPasswordEdit.NoEcho)
        pw3.setGeometry (x, y + 20, 100, 20)
        pw3.show ()

        y = y + 50

        urlLbl = TQLabel ("KURLLabel", self.page)
        urlLbl.setGeometry (x, y, 100, 20)
        urlLbl.show ()

        url = KURLLabel ("http://riverbankcomputing.co.uk", "PyTDE", self.page)
        url.setGeometry (x, y + 20, 100, 20)
        url.setUseTips (True)
        url.setTipText ("http://riverbankcomputing.co.uk")
        url.show ()

        x = 70
        y = y + 50

        bbLbl   = TQLabel ("KButtonBox", self.page)
        bbLbl.setGeometry (x, y, 75, 20)
        bbLbl.show ()

        bbox = KButtonBox (self.page, TQt.Horizontal)
        bbox.setGeometry (x, y + 20, 300, 22)
        bbox.addButton ("Button 1")
        bbox.addButton ("Button 2")
        bbox.addButton ("Button 3")
        bbox.show ()

        y = y + 50

#        dbLbl   = TQLabel ("KDirectionButton", self.page)
#        dbLbl.setGeometry (x, y, 95, 20)
#        dbLbl.show ()

#        dbUp    = KDirectionButton (TQt.UpArrow, self.page)
#        dbDown  = KDirectionButton (TQt.DownArrow, self.page)
#        dbRight = KDirectionButton (TQt.RightArrow, self.page)
#        dbLeft  = KDirectionButton (TQt.LeftArrow, self.page)

#        dbUp.setGeometry (x, y + 20, 22, 22)
#        dbDown.setGeometry (x + 30, y + 20, 22, 22)
#        dbRight.setGeometry (x + 60, y + 20, 22, 22)
#        dbLeft.setGeometry (x + 90, y + 20, 22, 22)

#        dbUp.show ()
#        dbDown.show ()
#        dbRight.show ()
#        dbLeft.show ()

        x = x + 150

#        kbLbl   = TQLabel ("KKeyButton", self.page)
#        kbLbl.setGeometry (x, y, 95, 20)
#        kbLbl.show ()

#        kb = KKeyButton (self.page)
#        kb.setText ("Enter")
#        kb.setGeometry (x, y + 20, 50, 32)
#        kb.show ()

        x = 70
        y = y + 50

#        tbLbl   = TQLabel ("KTabButton", self.page)
#        tbLbl.setGeometry (x, y, 95, 20)
#        tbLbl.show ()

#        tbUp    = KTabButton (TQt.UpArrow, self.page)
#        tbDown  = KTabButton (TQt.DownArrow, self.page)
#        tbRight = KTabButton (TQt.RightArrow, self.page)
#        tbLeft  = KTabButton (TQt.LeftArrow, self.page)

#        tbUp.setGeometry (x, y + 20, 22, 25)
#        tbDown.setGeometry (x + 30, y + 20, 22, 25)
#        tbRight.setGeometry (x + 60, y + 20, 22, 25)
#        tbLeft.setGeometry (x + 90, y + 20, 22, 25)

#        tbUp.show ()
#        tbDown.show ()
#        tbRight.show ()
#        tbLeft.show ()

class Page6:
    def __init__ (self, parent):
        self.page = parent.addPage ()

        x = 20
        y = 10

        red          = TQColor (255, 0, 0)
        green        = TQColor (0, 255, 0)
        yellow       = TQColor (255, 255, 0)
        blue         = TQColor (0, 0, 255)

        ledcolor     = [red, green, yellow, blue]
        ledshape     = [KLed.Rectangular, KLed.Circular]
        ledlook      = [KLed.Flat, KLed.Raised, KLed.Sunken]
        ledsize      = [10, 18, 25]
        self.ledlist = []

        for look in ledlook:
            for color in ledcolor:
                for shape in ledshape:
                    for size in ledsize:
                        led = KLed(color, KLed.On, look, shape,self.page)
                        led.setGeometry (x, y, size, size)
                        self.ledlist.append (led)
                        led.show ()
                        x = x + 50
                    x = x + 50
                x = 20
                y = y + 30
            y = y + 10

        toggle = TQPushButton ("Toggle", self.page)
        toggle.setGeometry (150, 400, 60, 22)
        toggle.show ()

        self.page.connect (toggle, TQ_SIGNAL ("clicked ()"), self.toggleClicked)

        self.page.show ()


    def toggleClicked (self):
        for led in self.ledlist:
            led.toggle ()

class Page7:
    def __init__ (self, parent):
        self.page = parent.addPage ()

        x = 10
        y = 10

        tabLbl   = TQLabel ("KTabCtl", self.page)
        tabLbl.setGeometry (x, y, 95, 20)
        tabLbl.show ()

        tab = KTabCtl (self.page)
        tab.setGeometry (x, y + 20, 300, 100)

        page1 = TQWidget (tab)
        p1Lbl = TQLabel ("This is page 1", page1)
        p1Lbl.setGeometry (20, 20, 100, 20)
        page2 = TQWidget (tab)
        p2Lbl = TQLabel ("This is page 2", page2)
        p2Lbl.setGeometry (50, 20, 100, 20)
        page3 = TQWidget (tab)
        p3Lbl = TQLabel ("This is page 3", page3)
        p3Lbl.setGeometry (20, 50, 100, 20)

        tab.addTab (page1, "Tab 1")
        tab.addTab (page2, "Tab 2")
        tab.addTab (page3, "Tab 3")
        tab.show ()

        x = 10
        y = 150

        progLbl   = TQLabel ("KProgress", self.page)
        progLbl.setGeometry (x, y + 50, 95, 20)
        progLbl.show ()

        self.p1 = KProgress (self.page)
        self.p2 = KProgress (15, self.page)
        self.p1.setRange (0, 25)
        self.p2.setRange (0, 25)

        self.p1.setGeometry (x, y + 80, 125, 20)
        self.p2.setGeometry (x, y + 120, 125, 20)

        self.p2.setPercentageVisible (0)

        self.p1.show ()
        self.p2.show ()

        self.total = 0

        y = y + 150
        sepLbl   = TQLabel ("KSeparator", self.page)
        sepLbl.setGeometry (x, y, 95, 20)
        sepLbl.show ()

        sep = KSeparator (TQFrame.HLine, self.page)
        sep.setGeometry (x, y + 20, 75, 10)
        sep.show ()


        self.page.show ()

        self.add1 (self)

    def add1 (self, junk = 0):
        self.total = self.total + 1
        self.p1.advance (1)
        self.p2.advance (1)

        if self.total < 26:
            TQTimer.singleShot (100, self.add1)



class Page8:
    def __init__ (self, parent):
        self.page = parent.addPage ()

        x = 40
        y = 10

        dpLbl   = TQLabel ("KDatePicker", self.page)
        dpLbl.setGeometry (x, y, 95, 20)
        dpLbl.show ()

        dp = KDatePicker (self.page)
        dp.setGeometry (x, y + 20, 300, 170)
        dp.show ()

        y = y + 210

        dtLbl   = TQLabel ("KDateTable", self.page)
        dtLbl.setGeometry (x, y, 95, 20)
        dtLbl.show ()

        dt = KDateTable (self.page)
        dt.setGeometry (x, y + 20, 300, 130)
        dt.show ()

class PageThisApp:
    def __init__ (self, parent):
        self.page = parent.addPage ()

        x = 10
        y = 10

        taLbl   = TQLabel ("This application uses TDEMainWindow as its top level widget\n and TDEListView in the"\
                          " left-hand panel", self.page)
        taLbl.setGeometry (x, y, 300, 60)
        taLbl.show ()

class PageNotImpl:
    def __init__ (self, parent):
        self.page = parent.addPage ()

        x = 10
        y = 10

        niLbl   = TQLabel ("Nothing is currently implemented for this widget", self.page)
        niLbl.setGeometry (x, y, 300, 20)
        niLbl.show ()

class CSDlg (KDialog):
    def __init__ (self, parent, name = "char select dlg", modal = False):
        KDialog.__init__ (self, parent, name, modal)

        self.setGeometry (150, 50, 700, 320)
        x = 10
        y = 10

        csLbl   = TQLabel ("KCharSelect", self)
        csLbl.setGeometry (x, y, 95, 20)
        csLbl.show ()

        cs = KCharSelect (self, "chselect", TQString.null, TQChar (' '), 0)
        cs.setGeometry (x, y + 20, 680, 250)
        cs.show ()

        closeBtn = TQPushButton ("Close", self)
        closeBtn.setGeometry ( 610, 280, 60, 22)
        closeBtn.show ()

        self.connect (closeBtn, TQ_SIGNAL ("clicked ()"), self.closeClicked)

    def closeClicked (self):
        self.done (1)

def widKAnimWidget (parent):
    parent.currentPageObj = PageNotImpl (parent)

def widKAuthIcon (parent):
    parent.currentPageObj = Page5 (parent)

def widKButtonBox (parent):
    parent.currentPageObj = Page5 (parent)

def widKCharSelect (parent):
    dlg = CSDlg (parent)
    dlg.show ()

def widKColorButton (parent):
    parent.currentPageObj = Page4 (parent)

def widKColorCells (parent):
    parent.currentPageObj = Page4 (parent)

def widKColorCombo (parent):
    parent.currentPageObj = Page2 (parent)

def widKColorPatch (parent):
    parent.currentPageObj = Page4 (parent)

def widKComboBox (parent):
    parent.currentPageObj = Page2 (parent)

def widTDECompletionBox (parent):
    parent.currentPageObj = PageNotImpl (parent)

def widKContainerLayout (parent):
    parent.currentPageObj = PageNotImpl (parent)

def widKCursor (parent):
    parent.currentPageObj = PageNotImpl (parent)

def widKDatePicker (parent):
    parent.currentPageObj = Page8 (parent)

def widKDateTable (parent):
    parent.currentPageObj = Page8 (parent)

def widKDirectionButton (parent):
    parent.currentPageObj = Page5 (parent)

def widKDualColorButton (parent):
    parent.currentPageObj = Page4 (parent)

def widKEdit (parent):
    parent.currentPageObj = Page1 (parent)

def widKEditListBox (parent):
    parent.currentPageObj = Page2 (parent)

def widTDEFontChooser (parent):
    parent.currentPageObj = Page3 (parent)

def widKHSSelector (parent):
    parent.currentPageObj = Page4 (parent)

def widTDEIconView (parent):
    parent.currentPageObj = PageNotImpl (parent)

def widKJanusWidget (parent):
    parent.currentPageObj = PageNotImpl (parent)

#def widKKeyButton (parent):
#    parent.currentPageObj = Page5 (parent)

def widKKeyChooser (parent):
    parent.currentPageObj = PageNotImpl (parent)

def widKLed (parent):
    parent.currentPageObj = Page6 (parent)

def widKLineEdit (parent):
    parent.currentPageObj = Page1 (parent)

def widTDEListBox (parent):
    parent.currentPageObj = Page2 (parent)

def widTDEListView (parent):
    parent.currentPageObj = PageThisApp (parent)

def widKNumInput (parent):
    parent.currentPageObj = Page1 (parent)

def widKPaletteTable (parent):
    parent.currentPageObj = Page4 (parent)

def widKPasswordEdit (parent):
    parent.currentPageObj = Page5 (parent)

def widKProgress (parent):
    parent.currentPageObj = Page7 (parent)

def widKRootPixmap (parent):
    parent.currentPageObj = PageNotImpl (parent)

def widTDEMainWindow (parent):
    parent.currentPageObj = PageThisApp (parent)

def widKRestrictedLine (parent):
    parent.currentPageObj = Page1 (parent)

def widKRuler (parent):
    parent.currentPageObj = PageNotImpl (parent)

def widTDESelector (parent):
    parent.currentPageObj = Page4 (parent)

def widKSeparator (parent):
    parent.currentPageObj = Page7 (parent)

def widKSqueezedTextLabel (parent):
    parent.currentPageObj = Page1 (parent)

def widKTabButton (parent):
    parent.currentPageObj = Page5 (parent)

def widKTabCtl (parent):
    parent.currentPageObj = Page7 (parent)

def widKTextBrowser (parent):
    parent.currentPageObj = PageNotImpl (parent)

def widKURLLabel (parent):
    parent.currentPageObj = Page5 (parent)


if __name__ == "__main__":
    print()
    print("Please run uisampler.py")
    print()
