/***************************************************************************
 *   Copyright (C) 2007 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef CLI_MAIN_H
#define CLI_MAIN_H

#include "common/global/about.h"
#include "common/global/log.h"
#include "cli_global.h"

namespace CLI
{
//-----------------------------------------------------------------------------
enum Property { NoProperty = 0, HasForce = 1, HasInteractiveMode = 2 };
TQ_DECLARE_FLAGS(Properties, Property)
TQ_DECLARE_OPERATORS_FOR_FLAGS(Properties)

extern const TDECmdLineOptions OPTIONS[];
//-----------------------------------------------------------------------------
struct CommandData {
  const char *name;
  int properties;
  const char *help;
};
extern const CommandData NORMAL_COMMAND_DATA[];
extern const CommandData INTERACTIVE_COMMAND_DATA[];
extern const CommandData *findCommandData(const TQString &command);
extern ExitCode findCommand(const TQString &s);
extern ExitCode commandList();

//-----------------------------------------------------------------------------
struct PropertyData
{
  const char *name, *optName, *alias, *help, *list, *listHelp;
};
extern const PropertyData PROPERTY_DATA[];
extern bool isPropertyList(const TQString &s);
extern bool isProperty(const TQString &s);
extern ExitCode propertyList();

//-----------------------------------------------------------------------------
class OptionList : public Piklab::OptionList
{
public:
  OptionList(Properties properties);
  OptionList(Properties properties, const TDECmdLineOptions *options);

private:
  void init(Properties properties);
};

//-----------------------------------------------------------------------------
class MainBase : public TQObject, public Log::Base
{
TQ_OBJECT
  
public:
  MainBase(Properties properties);
  virtual OptionList optionList(const char *fileDescription) const;
  virtual ExitCode doRun();
  virtual ExitCode list(const TQString &listName);
  virtual ExitCode prepareCommand(const TQString &command) = 0;
  virtual ExitCode executeCommand(const TQString &command) = 0;
  virtual ExitCode executeSetCommand(const TQString &property, const TQString &value) = 0;
  virtual TQString executeGetCommand(const TQString &property) = 0;

protected:
  Properties    _properties;
  TDECmdLineArgs *_args;

private:
  virtual ExitCode prepareRun(bool &interactive) = 0;
  virtual void init();
};

} // namespace

#endif
