/***************************************************************************
                          qdom_add.h  -  description
                             -------------------
    begin                : Wed Nov 21 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TQDOM_ADD_H
#define TQDOM_ADD_H

/** This file contains useful datatypes and functions in addition to the TQt DOM classes. */

#include <tqpixmap.h>
#include <tqdom.h>

class KXESearchDialog;

extern TQPixmap g_iconElement;
extern TQPixmap g_iconText;
extern TQPixmap g_iconComment;
extern TQPixmap g_iconCDATASection;
extern TQPixmap g_iconProcessingInstruction;
extern TQPixmap g_iconElement_b;
extern TQPixmap g_iconText_b;
extern TQPixmap g_iconComment_b;
extern TQPixmap g_iconCDATASection_b;
extern TQPixmap g_iconProcessingInstruction_b;

/** Returns the corresponding pixmap/icon to the given node type. */
const TQPixmap & domTool_getIconForNodeType( TQDomNode::NodeType type, bool );

/** Returns the path of the given node. */
TQString domTool_getPath( const TQDomNode & );

/** Returns the path of the given node. */
TQString domTool_getPath( const TQDomElement & );

/** Returns the level (how deep in tree) of the given node. */
unsigned int domTool_getLevel( const TQDomNode & );

/** Returns a TQString with the XML representation of the given node including all its children (uses @ref TQDomNode::save). */
TQString domTool_save( const TQDomNode &, int );

/**
 * Returns the previous node of the given one or an empty node, if it is the first.
 * This will be its previous siblings last grand child, if there is one.
 * Otherwise it is the previous sibling or,
 * if there is no sibling above, it will be its parent or
 * an empty node (if there is no parent).
 */
TQDomNode domTool_prevNode( const TQDomNode & node );
/**
 * Returns the next node of the given one or an empty node, if it is the last.
 * This will be it's first child,
 * if there are no childs, it will be the next sibling
 * and if there are no siblings below, it will be the parent's next sibling ...
 */
TQDomNode domTool_nextNode( const TQDomNode & node );

/**
 * Tests the given node and its (grand)childs.
 * Returns the node, which matches the given path, oran empty node (if no one matches).
 */
TQDomNode domTool_matchingNode( const TQDomNode & node, const TQString & szPath );

/** Tests, if the given node matches the conditions of the given search. */
bool domTool_match( TQDomNode node, const KXESearchDialog * const pConditions );

#endif

