//
//   File : kvi_scripteditor.cpp
//   Creation date : Sun Mar 28 1999 16:12:41 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#define __KVIRC__

#define _KVI_SCRIPTEDITOR_CPP_

#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"

#include "kvi_scripteditor.h"
#include "kvi_modulemanager.h"


KviScriptEditor::KviScriptEditor(TQWidget * par)
: TQWidget(par)
{
}


KviScriptEditor::~KviScriptEditor()
{
}

void KviScriptEditor::setText(const char * txt)
{
	setText(KviTQCString(txt));
}

void KviScriptEditor::setText(const KviTQCString &txt)
{
}

void KviScriptEditor::setText(const TQString &txt)
{
	setText(KviTQCString(txt.utf8()));
}

void KviScriptEditor::setFindText(const TQString &text)
{
}
void KviScriptEditor::setInfoText(const TQString &text)
{
}

void KviScriptEditor::setFindLineeditReadOnly(bool b)
{
}

void KviScriptEditor::getText(KviTQCString &txt)
{
}

void KviScriptEditor::setCursorPosition(TQPoint)
{
}

bool KviScriptEditor::isModified()
{
	return false;
}

TQPoint KviScriptEditor::getCursor()
{
	return TQPoint(0,0);
}
void KviScriptEditor::getText(TQString &txt)
{
	KviTQCString tmp;
	getText(tmp);
	txt = TQString::fromUtf8(tmp.data());
}

KviScriptEditor * KviScriptEditor::getDummyEditor(TQWidget * par)
{
	return new KviScriptEditor(par);
}


static KviScriptEditor * (*editorModuleCreateScriptEditor)(TQWidget *);
static void (*editorModuleDestroyScriptEditor)(KviScriptEditor *);


KviScriptEditor * KviScriptEditor::createInstance(TQWidget * par)
{
	KviModule * m = g_pModuleManager->getModule("editor");
	// If the module can't be loaded...return a dummy widget
// FIXME: #warning "Maybe provide some sort of basic default editable widget ?"
	if(!m)return KviScriptEditor::getDummyEditor(par); // dummy implementation


	editorModuleCreateScriptEditor = (KviScriptEditor * (*)(TQWidget *)) m->getSymbol("editor_module_createScriptEditor");

	if(!editorModuleCreateScriptEditor)return KviScriptEditor::getDummyEditor(par);

	return editorModuleCreateScriptEditor(par);

}

void KviScriptEditor::destroyInstance(KviScriptEditor * e)
{
	KviModule * m = g_pModuleManager->getModule("editor");
	if(!m)
	{
		delete e;
		return;
	}

	editorModuleDestroyScriptEditor = (void (*)(KviScriptEditor *)) m->getSymbol("editor_module_destroyScriptEditor");

	if(!editorModuleDestroyScriptEditor)
	{
		delete e;
		return;
	}

	editorModuleDestroyScriptEditor(e);
}

#include "kvi_scripteditor.moc"
