//============================================================================
//
//   File : kvi_modew.cpp
//   Creation date : 12.11.2005 23.50 by Uzhva Alexey
//
//   This file is part of the KVirc irc client distribution
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//============================================================================
#define __KVIRC__

#include "kvi_themedlabel.h"
#include "kvi_channel.h"
#include "kvi_options.h"
#include "kvi_ircconnectionserverinfo.h"
#include "kvi_ircconnectionuserinfo.h"
#include "kvi_qcstring.h"

#include <tqframe.h>
#include <tqlineedit.h>
#include "kvi_tal_hbox.h" 
#include <tqevent.h>

KviModeWidget::KviModeWidget(TQWidget * par,KviChannel* chan,const char * name)
:TQFrame(par,name)
{
	m_pChannel=chan;
	m_pLabel=0;
	m_pLineEdit=0;
	setBackgroundMode(TQWidget::NoBackground);
	reset();
}

KviModeWidget::~KviModeWidget()
{
}

void KviModeWidget::reset()
{
	if(m_pLineEdit)
	{
		delete m_pLineEdit;
		m_pLineEdit=0;
	}
	if(!m_pLabel)
		m_pLabel=new KviThemedLabel(this,0);
	refreshModes();
	m_pLabel->show();
	connect(m_pLabel,TQ_SIGNAL(doubleClicked()),this,TQ_SLOT(labelDoubleClick()));
	TQResizeEvent* ev=new TQResizeEvent(size(),size());
	resizeEvent(ev);
	delete ev;
	if(m_pChannel->input())
		m_pChannel->setFocus();
}

void KviModeWidget::refreshModes()
{
	TQString szMode=m_pChannel->channelMode();
	if(!m_pChannel->channelKey().isEmpty())
		szMode+=TQString(" k:%1").arg(m_pChannel->channelKey());
	if(!m_pChannel->channelLimit().isEmpty())
		szMode+=TQString(" l:%1").arg(m_pChannel->channelLimit().ptr());
	if(m_pLabel)
		m_pLabel->setText(szMode);
}

void KviModeWidget::applyOptions()
{
	if(m_pLabel)
		m_pLabel->applyOptions();
}

void KviModeWidget::resizeEvent(TQResizeEvent *e)
{
	if(e)TQFrame::resizeEvent(e);
	if(m_pLabel)
	{
		m_pLabel->setGeometry(0,0,width(),height());
	}
	if(m_pLineEdit)
	{
		m_pLineEdit->setGeometry(0,0,width(),height());
	}
}

void KviModeWidget::labelDoubleClick()
{
	if(m_pLabel && ( m_pChannel->isMeHalfOp() || m_pChannel->isMeOp() || m_pChannel->isMeChanOwner() || m_pChannel->isMeChanAdmin() || m_pChannel->connection()->userInfo()->hasUserMode('o') || m_pChannel->connection()->userInfo()->hasUserMode('O')) )
	{
		delete m_pLabel;
		m_pLabel=0;
		m_pLineEdit = new TQLineEdit(this,0);
		m_pLineEdit->setText(m_pChannel->channelMode());
		m_pLineEdit->show();
		m_pLineEdit->setFocus();
		resizeEvent(new TQResizeEvent(size(),size()));
		m_pLineEdit->installEventFilter( this );
		connect(m_pLineEdit,TQ_SIGNAL(textChanged ( const TQString & ) ),this,TQ_SLOT(editorTextChanged( const TQString & )));
	}
}

bool KviModeWidget::eventFilter( TQObject *obj, TQEvent *ev )
{
	if( (obj==m_pLineEdit) && ( ev->type() == TQEvent::KeyPress ) )
	{
		TQKeyEvent *keyEvent = (TQKeyEvent*)ev;
		switch(keyEvent->key())
		{
			case TQt::Key_Return:
			case TQt::Key_Enter:
				editorReturnPressed();
				return true;
			case TQt::Key_Escape:
				reset();
				return true;
		}
	}
	return TQFrame::eventFilter( obj, ev );
}

void KviModeWidget::editorReturnPressed()
{
	TQString szCurModes=m_pChannel->channelMode();
	TQString szNewModes=m_pLineEdit->text();
	TQString szMinusModes;
	for(unsigned int i=0; i<szCurModes.length(); i++)
	{
		if(szNewModes.contains(szCurModes[i]))
			szNewModes.remove(szCurModes[i]);
		else
			szMinusModes+=szCurModes[i];
	}
	TQString mode;
	if(!szMinusModes.isEmpty()) mode+=TQString("-"+szMinusModes);
	if(!szNewModes.isEmpty()) mode+=TQString("+"+szNewModes);
	if(!mode.isEmpty())
	{
		KviTQCString chan = m_pChannel->connection()->encodeText(m_pChannel->name());
		m_pChannel->connection()->sendFmtData("MODE %s %s",chan.data(),mode.utf8().data());
	}
	reset();
}

void KviModeWidget::editorTextChanged( const TQString & text)
{
	unsigned int i = 0;
	TQString szText=text;
	for(i=0;i<szText.length();i++)
	{
		if( !m_pChannel->connection()->serverInfo()->supportedPlainModes().contains(szText[i]) || 
			szText.find(szText[i])<static_cast<int>(i) )
			szText.remove(i,1);
	}	
	m_pLineEdit->setText(szText);
}

#include "kvi_modew.moc"
