/***************************************************************************
                          sq_ksquirrelpart.h  -  description
                             -------------------
    begin                : Thu Nov 29 2007
    copyright            : (C) 2007 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSQUIRRELPART_H
#define KSQUIRRELPART_H

#include <tdeparts/part.h>

class TDEAboutData;
class TDEToggleAction;
class TDESelectAction;

class SQ_GLWidget;

class KSquirrelPart;

class KSquirrelPartBrowserExtension: public KParts::BrowserExtension
{
    TQ_OBJECT
  

    public:
        KSquirrelPartBrowserExtension(KSquirrelPart* viewPart, const char *name = 0);
        ~KSquirrelPartBrowserExtension();

    public slots:
        void print();

    private:
        KSquirrelPart *mPart;
};

/***********************************************************/

class KSquirrelPart : public KParts::ReadOnlyPart
{
	TQ_OBJECT
  

    public:
	KSquirrelPart(TQWidget*, const char*, TQObject*, const char*, const TQStringList &);
	virtual ~KSquirrelPart();

	static TDEAboutData* createAboutData();

	TQString filePath();

	void print();

    protected:
       void partActivateEvent(KParts::PartActivateEvent *);

    protected slots:
        virtual bool openFile();
	virtual void setKonquerorWindowCaption(const KURL &url, const TQString &filename);

    private slots:
        void slotSelectionRect(bool);
        void slotSelectionEllipse(bool);
        void slotZoom();

    private:
        SQ_GLWidget *gl;
        TDEToggleAction *ar, *ae;
        TDESelectAction *sa;
        KSquirrelPartBrowserExtension *ext;
};

inline
TQString KSquirrelPart::filePath()
{
    return m_file;
}

#endif
