/***************************************************************************
 *   Copyright (C) by                                                      *
 *     - 2005: Christian Leh <moodwrod@web.de>                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CACHE_H
#define CACHE_H

#include <tqstring.h>
#include <tqsize.h>
#include <tqdir.h>

#include "scaler.h"

class Cache
{
  private:
    TQString mTheme;
    TQString mThemeEngine;
    TQDir mCacheDir;
  
    Scaler* mScaler;

    void createCacheDir();
    void writeInfoFile(TQString& file);
    bool isInSync(TQString& file);

    TQString getFile(TQString file);

  public:
    Cache(Scaler* scaler, const TQString& mThemeEngine, const TQString& theme);
    TQImage* cacheFile(const TQString& file);
};

#endif
