//
// C++ Interface: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KOMPOSEVIEWMANAGER_H
#define KOMPOSEVIEWMANAGER_H

#include <tqpoint.h>
#include <dcopobject.h>

#include "komposedcopiface.h"
#include "komposefullscreenwidget.h"

class KomposeTask;
class TQTimer;

/**
@author Hans Oischinger
*/
class KomposeViewManager : public TQObject, virtual public KomposeDcopIface
{
  TQ_OBJECT
protected:
  KomposeViewManager();
  ~KomposeViewManager();

public:
  static KomposeViewManager *instance();

  KomposeFullscreenWidget* getViewWidget() { return viewWidget; }

public slots:
  void createView( int type = -1 ); // -1 means the user's default
  void createVirtualDesktopView() { createView( KOMPOSEDISPLAY_VIRTUALDESKS ); }
  void createCurrentDesktopView() { createView( KOMPOSEDISPLAY_CURRENTDESK ); }
  void createWorldView() { createView( KOMPOSEDISPLAY_WORLD ); }
  void createDefaultView() { createView(); }

  void closeCurrentView();
  bool hasActiveView() { return activeView; }
  bool getBlockScreenshots() { return blockScreenshots; }
  int getDesktopBeforeSnaps() { return deskBeforeSnaps - 1; }

  void setCurrentDesktop( int desknum );
  void activateTask( KomposeTask* task );

protected slots:
  void toggleBlockScreenshots();
  void checkCursorPos();
  void reCheckCursorPos();

  void uglyTQtHackInitFunction();
  void slotStartCursorUpdateTimer();

signals:
  void viewClosed();

private:
  KomposeFullscreenWidget *viewWidget;    // the widget where all action takes place
  bool activeView;        // used to check if a view is active
  bool blockScreenshots;   // no screenshots when true
  int deskBeforeSnaps;    // the virtual desk we were on befor screenshots were taken

  TQTimer *cursorUpdateTimer;
  // The 4 corners
  TQPoint topLeftCorner;
  TQPoint topRightCorner;
  TQPoint bottomLeftCorner;
  TQPoint bottomRightCorner;
};

#endif
