/* This file is part of the KDE project
   Copyright (C)  2002 Montel Laurent <lmontel@mandrakesoft.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tdelocale.h>
#include "KWDocument.h"
#include <tqvbox.h>
#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqlistbox.h>
#include <tdemessagebox.h>
#include "KWCommand.h"
#include "KWCreateBookmarkDia.h"
#include "KWCreateBookmarkDiaBase.h"
#include "KWFrame.h"
#include "KWFrameSet.h"

KWCreateBookmarkDia::KWCreateBookmarkDia( const TQStringList & _list, TQWidget *parent, const char *name )
    : KDialogBase( parent, name , true, "", Ok|Cancel, Ok, true )
{
    setCaption( i18n("Create New Bookmark") );
    listBookMark = _list;
    init();
}

KWCreateBookmarkDia::KWCreateBookmarkDia( const TQStringList & _list, const TQString & _name, TQWidget *parent, const char *name )
    : KDialogBase( parent, name , true, "", Ok|Cancel, Ok, true )
{
    setCaption( i18n("Rename Bookmark") );
    listBookMark = _list;
    init();
    m_bookmarkName->setText(_name);
}

void KWCreateBookmarkDia::init()
{
    KWCreateBookmarkDiaBase *dia = new KWCreateBookmarkDiaBase( this );
    m_bookmarkName = dia->m_bookmarkName;
    enableButtonOK( false );
    connect( m_bookmarkName, TQ_SIGNAL(textChanged ( const TQString & )), this, TQ_SLOT(nameChanged( const TQString &)));
    setMainWidget( dia );
    m_bookmarkName->setFocus();
}

void KWCreateBookmarkDia::slotOk()
{
    if ( listBookMark.findIndex(m_bookmarkName->text() ) != -1 )
    {
        KMessageBox::error(this, i18n("That name already exists, please choose another name."));
    }
    else
        KDialogBase::slotOk();
}

TQString KWCreateBookmarkDia::bookmarkName()const
{
    return m_bookmarkName->text();
}

void KWCreateBookmarkDia::nameChanged( const TQString &text)
{
    enableButtonOK( !text.isEmpty() );
}


/* ****************************  */
KWSelectBookmarkDia::KWSelectBookmarkDia( const TQStringList & _list, KWDocument *_doc, TQWidget *parent, const char *name )
    : KDialogBase( parent, name , true, "", Ok|Cancel, Ok, true )
{
    m_doc=_doc;
    setCaption( i18n("Select Bookmark") );
    TQWidget *page = new TQWidget( this );
    setMainWidget(page);

    TQGridLayout * grid = new TQGridLayout(page, 5, 2, KDialog::marginHint(), KDialog::spacingHint());
    m_bookmarkList = new TQListBox( page );
    grid->addMultiCellWidget(m_bookmarkList, 0, 4, 0, 0);
    m_bookmarkList->insertStringList(_list);

    connect(m_bookmarkList,  TQ_SIGNAL( selectionChanged ()), this, TQ_SLOT(slotSelectionChanged()));
    connect(m_bookmarkList,  TQ_SIGNAL(doubleClicked ( TQListBoxItem * )), this, TQ_SLOT(slotOk()));
    connect(m_bookmarkList,  TQ_SIGNAL(returnPressed ( TQListBoxItem * )), this, TQ_SLOT(slotOk()));

    m_pbRename = new TQPushButton( i18n("Rename Bookmark"), page );
    grid->addWidget( m_pbRename, 0, 1);
    connect( m_pbRename, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotRenameBookmark()));

    m_pbDelete = new TQPushButton( i18n("Delete Bookmark"), page );
    grid->addWidget( m_pbDelete, 1, 1);

    connect( m_pbDelete, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotDeleteBookmark()));

    m_bookmarkList->setFocus();
    slotSelectionChanged();
}

void KWSelectBookmarkDia::slotRenameBookmark()
{
    TQString tmp =m_bookmarkList->currentText();
    if ( tmp.isEmpty() )
        return;
    //all bookmark name
    TQStringList lst =m_doc->listOfBookmarkName(0L);
    lst.remove( tmp );
    KWCreateBookmarkDia dia( lst, tmp, this, 0 );
    if ( dia.exec() ) {
        TQString newName = dia.bookmarkName();
        KWRenameBookmarkCommand *cmd = new KWRenameBookmarkCommand( i18n("Rename Bookmark"), tmp, newName, m_doc);
        m_doc->addCommand( cmd );
        cmd->execute();
        m_bookmarkList->changeItem ( newName, m_bookmarkList->currentItem() );
    }
}

void KWSelectBookmarkDia::slotDeleteBookmark()
{
    TQString tmp =m_bookmarkList->currentText();
    if ( !tmp.isEmpty())
    {
        m_doc->deleteBookmark(tmp);
        m_bookmarkList->removeItem(m_bookmarkList->currentItem());
    }
}


TQString KWSelectBookmarkDia::bookmarkSelected()const
{
    return m_bookmarkList->currentText();
}

void KWSelectBookmarkDia::slotSelectionChanged()
{
    bool state =!m_bookmarkList->currentText().isEmpty();
    enableButtonOK( state );
    m_pbRename->setEnabled( state);
    m_pbDelete->setEnabled( state && m_doc->isReadWrite());
}

#include "KWCreateBookmarkDia.moc"
