/* This file is part of the KDE project
   Copyright (C)  2002 Montel Laurent <lmontel@mandrakesoft.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "KWDocument.h"
#include "KWConfigFootNoteDia.h"
#include "KWConfigFootNoteDia.moc"
#include "KWVariable.h"
#include "KWCommand.h"
#include "KWFrameSet.h"

#include <KoParagDia.h>
#include <KoUnitWidgets.h>

#include <tdelocale.h>
#include <knuminput.h>

#include <tqradiobutton.h>
#include <tqwhatsthis.h>
#include <tqvbuttongroup.h>
#include <tqlabel.h>
#include <tqvbox.h>
#include <tqlayout.h>
#include <tqcombobox.h>


KWConfigFootNoteDia::KWConfigFootNoteDia( TQWidget *parent, const char *name, KWDocument *doc )
    : KDialogBase(Tabbed, TQString(), Ok | Cancel , Ok, parent, name, true)
{
    setCaption( i18n("Configure Endnote/Footnote") );
    m_doc = doc;

    resize( 510, 310 );
    setupTab1();
    setupTab2();
    setupTab3();
}

void KWConfigFootNoteDia::setupTab1()
{
    TQVBox * page = addVBoxPage( i18n( "Footnotes" ) );
    m_footNoteConfig = new KoCounterStyleWidget( false, true, false, page );
    //m_footNoteConfig->numTypeChanged( KoParagCounter::NUM_LIST );
    m_footNoteConfig->setCounter (static_cast<KWVariableSettings*>(m_doc->variableCollection()->variableSetting())->footNoteCounter() );
}

void KWConfigFootNoteDia::setupTab2()
{
    TQVBox * page = addVBoxPage( i18n( "Endnotes" ) );
    m_endNoteConfig = new KoCounterStyleWidget( false, true/*onlyStyleLetter*/,false, page );
    //m_endNoteConfig->numTypeChanged( KoParagCounter::NUM_LIST );
    m_endNoteConfig->setCounter (static_cast<KWVariableSettings*>(m_doc->variableCollection()->variableSetting())->endNoteCounter() );
}


void KWConfigFootNoteDia::setupTab3()
{
    TQFrame * page = addPage( i18n( "Separator Line" ) );
    TQString comment= i18n ("Configure the separator line. The separator line "
        "is drawn directly above the frame for the footnotes.");
    TQWhatsThis::add(page, comment);
    TQVBoxLayout *pageLayout= new TQVBoxLayout( page, 0, KDialog::spacingHint());

    TQButtonGroup *positionGroupBox = new TQButtonGroup( i18n( "Position"), page );
    comment= i18n ("The separator can be positioned horizontally by picking one "
        "of the three alignments.");
    TQWhatsThis::add(positionGroupBox, comment);
    positionGroupBox->setColumnLayout(0, TQt::Vertical );
    TQVBoxLayout *positionLayout = new TQVBoxLayout( positionGroupBox->layout() );
    positionLayout->setAlignment( TQt::AlignTop );

    // i18n context information necessary for gender considerations (e.g. in Polish)
    rbPosLeft = new TQRadioButton( i18n("Position", "Left"), positionGroupBox, "rbPosLeft" );
    positionLayout->addWidget( rbPosLeft );

    rbPosCentered = new TQRadioButton( i18n("Position", "Centered"), positionGroupBox, "rbPosCentered" );
    positionLayout->addWidget( rbPosCentered );

    rbPosRight = new TQRadioButton( i18n("Position", "Right"), positionGroupBox, "rbPosRight" );
    positionLayout->addWidget( rbPosRight );
    pageLayout->addWidget( positionGroupBox );
    switch( m_doc->footNoteSeparatorLinePosition() ) {
        case SLP_LEFT:
            rbPosLeft->setChecked( true);
            break;
        case SLP_CENTERED:
            rbPosCentered->setChecked( true);
            break;
        case SLP_RIGHT:
            rbPosRight->setChecked( true);
            break;
    }

    TQGridLayout *layout = new TQGridLayout( 0, 1, 1, 0, KDialog::spacingHint());

    spWidth = new KoUnitDoubleSpinBox(page, 0, 5, 0.5, m_doc->footNoteSeparatorLineWidth(), m_doc->unit(), 1);

    layout->addWidget( spWidth, 1, 1 );

    spLength = new KIntNumInput( page, "spLength" );
    spLength->setRange( 1, 100, 1,false );
    spLength->setValue( m_doc->footNoteSeparatorLineLength());
    spLength->setSuffix(i18n(" %"));
    layout->addWidget( spLength, 0, 1 );

    TQLabel *lSize = new TQLabel( i18n( "&Width:"), page );
    lSize->setBuddy( spWidth );
    comment= i18n ("The width is the thickness of the separator line, set to 0 for no separator line.");
    TQWhatsThis::add(lSize, comment);
    TQWhatsThis::add(spWidth, comment);
    layout->addWidget( lSize, 1, 0 );

    TQSpacerItem* spacer = new TQSpacerItem( 0, 0, TQSizePolicy::Expanding, TQSizePolicy::Minimum );
    layout->addMultiCell( spacer, 0, 1, 2, 2 );

    TQLabel *lWidth = new TQLabel( i18n("&Size on page:"), page, "lWidth" );
    lWidth->setBuddy( spLength );
    comment= i18n ("The size of the separator line can be defined as a percentage of the width of the page.");
    TQWhatsThis::add(spLength, comment);
    TQWhatsThis::add(lWidth, comment);
    layout->addWidget( lWidth, 0, 0 );
    pageLayout->addLayout( layout );

    TQHBoxLayout *styleLayout = new TQHBoxLayout( 0, 0, KDialog::spacingHint(), "styleLayout");

    TQLabel *styleLabel = new TQLabel( i18n("Style:"), page );
    styleLayout->addWidget( styleLabel );

    m_cbLineType = new TQComboBox( page );
    TQStringList lst;
    lst <<i18n("Solid");
    lst <<i18n("Dash Line");
    lst <<i18n("Dot Line");
    lst <<i18n("Dash Dot Line");
    lst <<i18n("Dash Dot Dot Line");
    m_cbLineType->insertStringList( lst );
    m_cbLineType->setCurrentItem( static_cast<int>(m_doc->footNoteSeparatorLineType()));
    comment= i18n ("The separator line can be drawn as a solid line or as a line which has a "
        "pattern; the pattern can be set in the style-type.");
    TQWhatsThis::add(styleLabel, comment);
    TQWhatsThis::add(m_cbLineType, comment);
    styleLayout->addWidget( m_cbLineType );

    TQSpacerItem* spacer_2 = new TQSpacerItem( 0, 0, TQSizePolicy::Expanding, TQSizePolicy::Minimum );
    styleLayout->addItem( spacer_2 );
    pageLayout->addLayout( styleLayout );
    TQSpacerItem* spacer_3 = new TQSpacerItem( 0, 0, TQSizePolicy::Minimum, TQSizePolicy::Expanding );
    pageLayout->addItem( spacer_3 );
}


void KWConfigFootNoteDia::slotOk()
{
    KMacroCommand * macro = 0L;
    KCommand *cmd = 0L;
    KoParagCounter counter =static_cast<KWVariableSettings*>(m_doc->variableCollection()->variableSetting())->footNoteCounter();
    if (counter != m_footNoteConfig->counter() )
    {
        macro = new KMacroCommand(i18n("Change End-/Footnote Variable Settings"));
        cmd= new KWChangeFootEndNoteSettingsCommand( i18n("Change End-/Footnote Variable Settings") , counter, m_footNoteConfig->counter() ,true ,m_doc);
        macro->addCommand(cmd );
    }
    counter = static_cast<KWVariableSettings*>(m_doc->variableCollection()->variableSetting())->endNoteCounter();
    if (counter != m_endNoteConfig->counter() )
    {
        if ( !macro )
            macro = new KMacroCommand(i18n("Change End-/Footnote Variable Settings"));
        cmd= new KWChangeFootEndNoteSettingsCommand( i18n("Change End-/Footnote Variable Settings") , counter, m_endNoteConfig->counter() ,false ,m_doc);
        macro->addCommand(cmd );
    }

    int val =spLength->value();
    double width = spWidth->value();
    SeparatorLinePos tmp = SLP_LEFT;
    SeparatorLineLineType type = static_cast<SeparatorLineLineType>(m_cbLineType->currentItem());
    if ( rbPosRight->isChecked())
        tmp = SLP_RIGHT;
    else if ( rbPosCentered->isChecked())
        tmp = SLP_CENTERED;
    else if ( rbPosLeft->isChecked())
        tmp = SLP_LEFT;

    if ( (val != m_doc->footNoteSeparatorLineLength())||
         tmp != m_doc->footNoteSeparatorLinePosition()||
         width!= m_doc->footNoteSeparatorLineWidth() ||
         type != m_doc->footNoteSeparatorLineType())
    {
        if ( !macro )
            macro = new KMacroCommand(i18n("Change Footnote Line Separator Settings"));
        cmd = new KWChangeFootNoteLineSeparatorParametersCommand( i18n("Change Footnote Line Separator Settings") , m_doc->footNoteSeparatorLinePosition(), tmp, m_doc->footNoteSeparatorLineLength(), val,m_doc->footNoteSeparatorLineWidth(), width, m_doc->footNoteSeparatorLineType(), type, m_doc);
        macro->addCommand( cmd );
    }

   if ( macro )
    {
        macro->execute();
        m_doc->addCommand( macro );
    }

    KDialogBase::slotOk();
}
