// Copyright (c) 2000 Phil Thompson <phil@river-bank.demon.co.uk>
//
// This file contains the definition of the interface to the Kugar KPart.


#ifndef _KUGAR_PART_H
#define _KUGAR_PART_H

#include <KoDocument.h>

#include "mpagecollection.h"
#include "mreportengine.h"

class TDEInstance;
class KugarBrowserExtension;

class KugarPart: public KoDocument
{
    TQ_OBJECT
  

public:
    KugarPart( TQWidget *parentWidget = 0, const char *widgetName = 0, 
               TQObject* parent = 0,
               const char* name = 0, bool singleViewMode = false );
    virtual ~KugarPart();

    virtual bool initDoc( InitDocFlags flags, TQWidget* parentWidget = 0 );

    virtual bool loadOasis( const TQDomDocument&, KoOasisStyles&, 
                            const TQDomDocument&, KoStore* );
    virtual bool saveOasis( KoStore*, KoXmlWriter* );

    virtual bool loadXML( TQIODevice *, const TQDomDocument & );
    //  virtual TQDomDocument saveXML();

    virtual void paintContent( TQPainter&, const TQRect&,
                               bool /*transparent*/ = false,
                               double /*zoomX*/ = 1.0, double /*zoomY*/ = 1.0 )
    {
        ;
    }

    Kugar::MReportEngine *reportEngine()
    {
        return m_reportEngine;
    }

protected:
    virtual KoView* createViewInstance( TQWidget* parent, const char* name );

public slots:
    void setForcedUserTemplate( const TQString &/*name*/ )
    {
        ;
    }

private slots:
    void slotPreferredTemplate( const TQString & );

private:
    TQString m_reportData;
    Kugar::MReportEngine *m_reportEngine;
    bool m_templateOk;
    KURL m_docURL;
};


#endif
