/* This file is part of the KDE project
   Copyright (C) 2004,2006 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "kexitimetableedit.h"

#include <tqapplication.h>
#include <tqpainter.h>
#include <tqvariant.h>
#include <tqrect.h>
#include <tqpalette.h>
#include <tqcolor.h>
#include <tqfontmetrics.h>
#include <tqdatetime.h>
#include <tqcursor.h>
#include <tqpoint.h>
#include <tqlayout.h>
#include <tqtoolbutton.h>
#include <tqdatetimeedit.h>
#include <tqclipboard.h>

#include <kdebug.h>
#include <tdelocale.h>
#include <tdeglobal.h>
#include <kdatepicker.h>
#include <kdatetbl.h>
#include <klineedit.h>
#include <tdepopupmenu.h>
#include <kdatewidget.h>

#include <kexiutils/utils.h>

KexiTimeTableEdit::KexiTimeTableEdit(KexiTableViewColumn &column, TQWidget *parent)
 : KexiInputTableEdit(column, parent)
{
	setName("KexiTimeTableEdit");

//! @todo add TQValidator so time like "99:88:77" cannot be even entered

	m_lineedit->setInputMask( m_formatter.inputMask() );
}

KexiTimeTableEdit::~KexiTimeTableEdit()
{
}

void KexiTimeTableEdit::setValueInInternalEditor(const TQVariant &value)
{
	if (value.isValid() && value.toTime().isValid()) 
		m_lineedit->setText( m_formatter.timeToString( value.toTime() ) );
	else
		m_lineedit->setText( TQString() );
}

void KexiTimeTableEdit::setValueInternal(const TQVariant& add_, bool removeOld)
{
	if (removeOld) {
		//new time entering... just fill the line edit
//! @todo cut string if too long..
		TQString add(add_.toString());
		m_lineedit->setText(add);
		m_lineedit->setCursorPosition(add.length());
		return;
	}
	setValueInInternalEditor( m_origValue );
	m_lineedit->setCursorPosition(0); //ok?
}

void KexiTimeTableEdit::setupContents( TQPainter *p, bool focused, const TQVariant& val,  
	TQString &txt, int &align, int &x, int &y_offset, int &w, int &h )
{
	Q_UNUSED(p);
	Q_UNUSED(focused);
	Q_UNUSED(x);
	Q_UNUSED(w);
	Q_UNUSED(h);
#ifdef TQ_WS_WIN
	y_offset = -1;
#else
	y_offset = 0;
#endif
	if (!val.isNull() && val.canCast(TQVariant::Time))
		txt = m_formatter.timeToString(val.toTime());
	align |= AlignLeft;
}

bool KexiTimeTableEdit::valueIsNull()
{
	if (m_formatter.isEmpty( m_lineedit->text() )) //empty time is null
		return true;
	return !timeValue().isValid();
}

bool KexiTimeTableEdit::valueIsEmpty()
{
	return valueIsNull();// OK? TODO (nonsense?)
}

TQTime KexiTimeTableEdit::timeValue()
{
	return m_formatter.stringToTime( m_lineedit->text() );
}

TQVariant KexiTimeTableEdit::value()
{
	return m_formatter.stringToVariant( m_lineedit->text() );
}

bool KexiTimeTableEdit::valueIsValid()
{
	if (m_formatter.isEmpty( m_lineedit->text() )) //empty time is valid
		return true;
	return m_formatter.stringToTime( m_lineedit->text() ).isValid();
}

void KexiTimeTableEdit::handleCopyAction(const TQVariant& value, const TQVariant& visibleValue)
{
	Q_UNUSED(visibleValue);
	if (!value.isNull() && value.toTime().isValid())
		tqApp->clipboard()->setText( m_formatter.timeToString(value.toTime()) );
	else
		tqApp->clipboard()->setText( TQString() );
}

void KexiTimeTableEdit::handleAction(const TQString& actionName)
{
	const bool alreadyVisible = m_lineedit->isVisible();

	if (actionName=="edit_paste") {
		const TQVariant newValue( m_formatter.stringToTime( tqApp->clipboard()->text() ) );
		if (!alreadyVisible) { //paste as the entire text if the cell was not in edit mode
			emit editRequested();
			m_lineedit->clear();
		}
		setValueInInternalEditor( newValue );
	}
	else
		KexiInputTableEdit::handleAction(actionName);
}

KEXI_CELLEDITOR_FACTORY_ITEM_IMPL(KexiTimeEditorFactoryItem, KexiTimeTableEdit)

#include "kexitimetableedit.moc"
