/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2004-2006 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXIDBFACTORY_H
#define KEXIDBFACTORY_H

#include <formeditor/widgetfactory.h>

class TDEAction;

namespace KFormDesigner {
	class Form;
	class FormManager;
}

//! Kexi Factory (DB widgets + subform)
class KexiDBFactory : public KFormDesigner::WidgetFactory
{
	TQ_OBJECT
  

	public:
		KexiDBFactory(TQObject *parent, const char *name, const TQStringList &args);
		virtual ~KexiDBFactory();

		virtual TQWidget *createWidget(const TQCString &classname, TQWidget *parent, const char *name, 
			KFormDesigner::Container *container, int options = DefaultOptions );

		virtual void createCustomActions(TDEActionCollection* col);
		virtual bool createMenuActions(const TQCString &classname, TQWidget *w, TQPopupMenu *menu,
		   KFormDesigner::Container *container);
		virtual bool startEditing(const TQCString &classname, TQWidget *w, KFormDesigner::Container *container);
		virtual bool previewWidget(const TQCString &, TQWidget *, KFormDesigner::Container *);
		virtual bool clearWidgetContent(const TQCString &classname, TQWidget *w);

		//virtual void		saveSpecialProperty(const TQString &classname, const TQString &name, const TQVariant &value, TQWidget *w,
		         //TQDomElement &parentNode, TQDomDocument &parent) {}
		//virtual void            readSpecialProperty(const TQCString &classname, TQDomElement &node, TQWidget *w, KFormDesigner::ObjectTreeItem *item) {}
		virtual TQValueList<TQCString> autoSaveProperties(const TQCString &classname);

	protected slots:
		void slotImageBoxIdChanged(long id); /*KexiBLOBBuffer::Id_t*/

	protected:
		virtual bool changeText(const TQString &newText);
		virtual void resizeEditor(TQWidget *editor, TQWidget *widget, const TQCString &classname);

		virtual bool isPropertyVisibleInternal(const TQCString& classname, TQWidget *w,
			const TQCString& property, bool isTopLevel);

		//! Sometimes property sets should be reloaded when a given property value changed.
		virtual bool propertySetShouldBeReloadedAfterPropertyChange(const TQCString& classname, TQWidget *w, 
			const TQCString& property);

		TDEAction* m_assignAction;
};

#endif
