/* This file is part of the KDE project
   Copyright (C) 2004-2005 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <kexidb/msghandler.h>

using namespace KexiDB;

MessageTitle::MessageTitle(Object* o, const TQString& msg)
	: m_obj(o)
	, m_prevMsgTitle(o->m_msgTitle)
{ 
	m_obj->m_msgTitle = msg;
}

MessageTitle::~MessageTitle()
{
	m_obj->m_msgTitle = m_prevMsgTitle;
}

//------------------------------------------------

MessageHandler::MessageHandler(TQWidget *parent)
 : m_messageHandlerParentWidget(parent)
 , m_enableMessages(true)
{
}

MessageHandler::~MessageHandler()
{
}

int MessageHandler::askQuestion( const TQString& message, 
	KMessageBox::DialogType dlgType, KMessageBox::ButtonCode defaultResult,
	const KGuiItem &buttonYes, 
	const KGuiItem &buttonNo,
	const TQString &dontShowAskAgainName,
	int options )
{
	Q_UNUSED(message);
	Q_UNUSED(dlgType);
	Q_UNUSED(buttonYes);
	Q_UNUSED(buttonNo);
	Q_UNUSED(dontShowAskAgainName);
	Q_UNUSED(options);
	return defaultResult;
}
