/* This file is part of the KDE project
   Copyright (C) 2001, The Karbon Developers
   Copyright (C) 2002, The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.

*/

#ifndef __VPAINTER_H__
#define __VPAINTER_H__

// painter abstraction

#include <tqnamespace.h>
#include <KoRect.h>
#include <vfillrule.h>

class TQWMatrix;
class TQPaintDevice;
class TQColor;
class TQPen;
class TQBrush;
class TQImage;

class VStroke;
class VFill;

class KoPoint;
class KoRect;

class VPainter
{
public:
	VPainter( TQPaintDevice *, unsigned int /*w*/ = 0, unsigned int /*h*/ = 0 ) {};
	virtual ~VPainter() {};

	//
	virtual void resize( unsigned int w, unsigned int h ) = 0;
	virtual void begin() = 0;
	virtual void end() = 0;
	virtual void blit( const KoRect & ) = 0;
	virtual void clear( const TQColor & ) = 0;
	virtual void clear( const KoRect &, const TQColor & ) = 0;

	// matrix manipulation
	virtual void setWorldMatrix( const TQWMatrix & ) = 0;
	virtual const TQWMatrix worldMatrix() = 0;
	virtual void setZoomFactor( double ) = 0;
	virtual double zoomFactor() { return 1.0; }

	// drawing
	virtual void moveTo( const KoPoint & ) = 0;
	virtual void lineTo( const KoPoint & ) = 0;
	virtual void curveTo( const KoPoint &, const KoPoint &, const KoPoint & ) = 0;
	virtual void newPath() = 0;
	virtual void strokePath() = 0;
	virtual void fillPath() = 0;
	virtual void setFillRule( VFillRule ) = 0;
	virtual void setClipPath() = 0;
	virtual void resetClipPath() = 0;

	// helper
	virtual void drawNode( const KoPoint& , int ) {}
	virtual void drawRect( const KoRect & ) {}
	virtual void drawRect( double, double, double, double ) {}

	// pen + brush
	virtual void setPen( const VStroke & ) = 0;
	// compatibility, use VPen/VBrush later ?
	virtual void setPen( const TQColor & ) = 0;
	virtual void setPen( TQt::PenStyle style ) = 0;
	virtual void setBrush( const VFill & ) = 0;
	virtual void setBrush( const TQColor & ) = 0;
	virtual void setBrush( TQt::BrushStyle style ) = 0;

	virtual void drawImage( const TQImage &, const TQWMatrix & ) {}

	// stack management
	virtual void save() = 0;
	virtual void restore() = 0;

	// we have to see how this fits in
	virtual void setRasterOp( TQt::RasterOp ) = 0;

	// access to device
	virtual TQPaintDevice *device() = 0;
};

#endif
