/*
   This file is part of the KDE project
   Copyright 2001, 2002 Nicolas GOUTTE <goutte@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef EXPORTFILTERFULLPOWER_H
#define EXPORTFILTERFULLPOWER_H

#include <tqvaluestack.h>
#include <tqvaluelist.h>
#include <tqstringlist.h>

#include <KWEFBaseWorker.h>

class ListInfo
{
public:
    CounterData::Style m_typeList; ///< What is the style of the current list (undefined, if we are not in a list)
    bool m_orderedList; ///< Is the current list ordered or not (undefined, if we are not in a list)
};

class RTFWorker : public KWEFBaseWorker
{
public:
    RTFWorker(void);
    virtual ~RTFWorker(void) { delete m_streamOut; delete m_ioDevice; }
public:
    virtual bool doOpenFile(const TQString& filenameOut, const TQString& to);
    virtual bool doCloseFile(void); ///< Close file in normal conditions
    virtual bool doOpenDocument(void);
    virtual bool doCloseDocument(void);
    virtual bool doFullParagraph(const TQString& paraText, const LayoutData& layout,
        const ValueListFormatData& paraFormatDataList);
    virtual bool doFullDocumentInfo(const KWEFDocumentInfo& docInfo);
    virtual bool doOpenTextFrameSet(void);
    virtual bool doCloseTextFrameSet(void);
    virtual bool doFullPaperFormat(const int format,
        const double width, const double height, const int orientation);
    virtual bool doFullPaperBorders (const double top, const double left,
        const double bottom, const double right);
    virtual bool doFullDefineStyle(LayoutData& layout);
    virtual bool doHeader(const HeaderData& header);
    virtual bool doFooter(const FooterData& footer);
    virtual bool doVariableSettings(const VariableSettingsData& vs);

private:
    TQString openSpan(const FormatData& formatOrigin, const FormatData& format);
    TQString closeSpan(const FormatData& formatOrigin, const FormatData& format);
    /** 
     * Encodes the @p text into
     * RTF seven bit ASCII. This affects any 8 bit characters.
     * They are encoded either with \\' or with \\u
     * @return the escaped string
     */
    TQString escapeRtfText ( const TQString& text ) const;
    TQString ProcessParagraphData ( const TQString &paraText,
        const LayoutData& layout, const ValueListFormatData &paraFormatDataList);
    TQString formatTextParagraph(const TQString& strText,
        const FormatData& formatOrigin, const FormatData& format);
    TQString makeTable(const FrameAnchor& anchor);
    bool convertUnknownPicture(const TQString& strName, const TQString& extension, TQByteArray& image);
    TQString makeImage(const FrameAnchor& anchor);
    void writeFontData(void);
    void writeColorData(void);
    void writeStyleData(void);
    TQString textFormatToRtf(const TextFormatting& formatOrigin,
        const TextFormatting& formatData, const bool force);
    TQString layoutToRtf(const LayoutData& layoutOrigin,
        const LayoutData& layout, const bool force);
    TQString lookupFont(const TQString& markup, const TQString& fontName);
    TQString lookupColor(const TQString& markup, const TQColor& color);
    TQString lookupStyle(const TQString& styleName, LayoutData& returnLayout);
    TQString writeRow(const TQString& textCellHeader, const TQString& rowText, const FrameData& frame);
    TQString writeBorder(const char whichBorder, const int borderWidth, const TQColor& color);
protected:
    TQIODevice* m_ioDevice;
    TQTextStream* m_streamOut;
    TQString m_eol;
    TQString m_textDocInfo;
    TQString m_textPage;
    TQString m_textBody;
    TQString m_fileName; ///< Name of the output file
    TQValueStack<ListInfo> m_listStack; ///< Stack for list information
    TQStringList m_fontList;
    TQValueList<TQColor> m_colorList;
    TQValueList<LayoutData> m_styleList;
    bool m_inTable;
    bool m_paperOrientation;
    double m_paperWidth, m_paperHeight;
    double m_paperMarginTop, m_paperMarginLeft, m_paperMarginBottom, m_paperMarginRight;
    TQString m_prefix;
    int m_startPageNumber;
};

#endif /* EXPORTFILTERFULLPOWER_H */
