/*
 *  Copyright (c) 2004 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
 
#include "kis_autobrush.h"
#include <KoImageResource.h>
#include <kdebug.h>
#include <tqspinbox.h>
#include <tqtoolbutton.h>
#include <tqimage.h>
#include <tqcombobox.h>
#include <tqlabel.h>


KisAutobrush::KisAutobrush(TQWidget *parent, const char* name, const TQString& caption) : KisWdgAutobrush(parent, name)
{
    setCaption(caption);

    m_linkSize = true;
    m_linkFade = true;
    
    linkFadeToggled(m_linkSize);
    linkSizeToggled(m_linkFade);

    connect(bnLinkSize, TQ_SIGNAL(toggled(bool)), this, TQ_SLOT(linkSizeToggled( bool )));
    connect(bnLinkFade, TQ_SIGNAL(toggled(bool)), this, TQ_SLOT(linkFadeToggled( bool )));
    
    connect((TQObject*)comboBoxShape, TQ_SIGNAL(activated(int)), this, TQ_SLOT(paramChanged()));
    spinBoxWidth->setMinValue(1);
    connect(spinBoxWidth,TQ_SIGNAL(valueChanged(int)),this,TQ_SLOT(spinBoxWidthChanged(int)));
    spinBoxHeight->setMinValue(1);
    connect(spinBoxHeight,TQ_SIGNAL(valueChanged(int)),this,TQ_SLOT(spinBoxHeightChanged(int)));
    spinBoxHorizontal->setMinValue(0);
    connect(spinBoxHorizontal,TQ_SIGNAL(valueChanged(int)),this,TQ_SLOT(spinBoxHorizontalChanged(int)));
    spinBoxVertical->setMinValue(0);
    connect(spinBoxVertical,TQ_SIGNAL(valueChanged(int)),this,TQ_SLOT(spinBoxVerticalChanged(int)));

    m_brsh = new TQImage(1,1,32);
    TQ_CHECK_PTR(m_brsh);

    paramChanged();


    connect(brushPreview, TQ_SIGNAL(clicked()), TQ_SLOT(paramChanged()));

}

void KisAutobrush::resizeEvent ( TQResizeEvent * )
{
    brushPreview->setMinimumHeight(brushPreview->width()); // dirty hack !
    brushPreview->setMaximumHeight(brushPreview->width()); // dirty hack !
}

void KisAutobrush::activate()
{
    paramChanged();
}

void KisAutobrush::paramChanged()
{
    TQ_INT32 fh = TQMIN( spinBoxWidth->value()/2, spinBoxHorizontal->value() ) ;
    TQ_INT32 fv = TQMIN( spinBoxHeight->value()/2, spinBoxVertical->value() );
    KisAutobrushShape* kas;

    if(comboBoxShape->currentItem() == 0) // use index compare instead of comparing a translatable string
    {
        kas = new KisAutobrushCircleShape(spinBoxWidth->value(),  spinBoxHeight->value(), fh, fv);
        TQ_CHECK_PTR(kas);

    } else {
        kas = new KisAutobrushRectShape(spinBoxWidth->value(),  spinBoxHeight->value(), fh, fv);
        TQ_CHECK_PTR(kas);

    }
    kas->createBrush(m_brsh);

    TQPixmap p;
    TQImage pi(*m_brsh);
    double coeff = 1.0;
    int bPw = brushPreview->width()-3;
    if(pi.width() > bPw)
    {
        coeff =  bPw /(double)pi.width();
    }
    int bPh = brushPreview->height()-3;
    if(pi.height() > coeff * bPh)
    {
        coeff = bPh /(double)pi.height();
    }
    if( coeff < 1.0)
    {
        pi = pi.smoothScale( (int)(coeff * pi.width()) , (int)(coeff * pi.height()));
    }
    
    p.convertFromImage(pi);
    brushPreview->setPixmap(p);
    KisAutobrushResource * resource = new KisAutobrushResource(*m_brsh);
    TQ_CHECK_PTR(resource);

    emit(activatedResource(resource));
    delete kas;
}
void KisAutobrush::spinBoxWidthChanged(int a)
{
    spinBoxHorizontal->setMaxValue(a/2);
    if(m_linkSize)
    {
        spinBoxHeight->setValue(a);
        spinBoxVertical->setMaxValue(a/2);
    }
    this->paramChanged();
}
void KisAutobrush::spinBoxHeightChanged(int a)
{
    spinBoxVertical->setMaxValue(a/2);
    if(m_linkSize)
    {
        spinBoxWidth->setValue(a);
        spinBoxHorizontal->setMaxValue(a/2);
    }
    this->paramChanged();
}
void KisAutobrush::spinBoxHorizontalChanged(int a)
{
    if(m_linkFade)
        spinBoxVertical->setValue(a);
    this->paramChanged();
}
void KisAutobrush::spinBoxVerticalChanged(int a)
{
    if(m_linkFade)
        spinBoxHorizontal->setValue(a);
    this->paramChanged();
}

void KisAutobrush::linkSizeToggled(bool b)
{
    m_linkSize = b;

    KoImageResource kir;
    if (b) {
        bnLinkSize->setPixmap(kir.chain());
    }
    else {
        bnLinkSize->setPixmap(kir.chainBroken());
    }
}

void KisAutobrush::linkFadeToggled(bool b)
{
    m_linkFade = b;

    KoImageResource kir;
    if (b) {
        bnLinkFade->setPixmap(kir.chain());
    }
    else {
        bnLinkFade->setPixmap(kir.chainBroken());
    }
}


#include "kis_autobrush.moc"
