/***************************************************************************
                          list_pgn.cpp  -  description
                             -------------------
    begin                : Thu Dec 13 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "list_pgn.moc"
#include <tdelistview.h>
#include <kstatusbar.h>
#include <kprogress.h>
#include <tqhbox.h>
#include "resource.h"
#include "match_param.h"

list_pgn::list_pgn(TQWidget *parent, const char *name) : TQVBox(parent,name)
{
	listView = new TDEListView( this, "listView" );
	listView->addColumn( i18n( "Result" ) );
	listView->addColumn( i18n( "White" ) );
	listView->addColumn( i18n( "Black" ) );
	listView->addColumn( i18n( "Round" ) );
	listView->addColumn( i18n( "Site" ) );
	listView->addColumn( i18n( "Date" ) );
	listView->setSorting( 1 );
	listView->setAllColumnsShowFocus( true );
	listView->setMultiSelection( false );
	listView->setShowSortIndicator( true );
	listView->restoreLayout( kapp->config(), "PGN_ListView" );
	listView->show();
	connect( listView, TQ_SIGNAL( executed( TQListViewItem* ) ), this, TQ_SLOT( slot_selected( TQListViewItem* ) ) );

	/*
			Showing listView while scanning can mean the difference between
			a 12 second load time and a 40 second load time. dummyView is
			just a placeholder for listView while scanning.
	*/
	dummyView = new TDEListView( this, "dummyView" );
	dummyView->addColumn( i18n( "Result" ) );
	dummyView->addColumn( i18n( "White" ) );
	dummyView->addColumn( i18n( "Black" ) );
	dummyView->addColumn( i18n( "Round" ) );
	dummyView->addColumn( i18n( "Site" ) );
	dummyView->addColumn( i18n( "Date" ) );
	dummyView->restoreLayout( kapp->config(), "PGN_ListView" );
	dummyView->hide();

	statusBox = new TQHBox( this, "statusBox" );
	status = new KStatusBar( statusBox, "status" );

	progress = new KProgress( statusBox, "progress" );
	progress->setValue( 0 );

	show();
}
list_pgn::~list_pgn()
{
	listView->saveLayout( kapp->config(), "PGN_ListView" );
}
///////////////////////////////////////
//
//	list_pgn::setURL
//
///////////////////////////////////////
void list_pgn::setURL( TQString URL )
{
	myURL = URL;
	listView->clear();
	setCaption( URL );

	if( tmpPGN.open( URL ) == false )
	{
		status->message( i18n( "Can not open %1" ).arg( URL ) );
		return;
	}
	listView->hide();
	dummyView->show();
	startTimer( 0 );
}
///////////////////////////////////////
//
//	list_pgn::setProgress
//
///////////////////////////////////////
void list_pgn::setProgress( const int num )
{
	progress->setValue( num );
	if( num == 100 )
		progress->setEnabled( false );
	else
		progress->setEnabled( true );
}
///////////////////////////////////////
//
//	list_pgn::slot_selected
//
///////////////////////////////////////
void list_pgn::slot_selected( TQListViewItem *item )
{
	emit selected( myURL, item->text(6).toInt() );
}
///////////////////////////////////////
//
//	list_pgn::timerEvent
//
///////////////////////////////////////
void list_pgn::timerEvent( TQTimerEvent* )
{
	int fileProgress;

	fileProgress = tmpPGN.scan();
	setProgress( fileProgress );
	if( tmpPGN.TAG_White.isEmpty() )
	{
		if( listView->childCount() == 1 )
		{
			emit selected( myURL, 0 );
		}
		this->killTimers();
		listView->show();
		dummyView->hide();
	}
	else
	{
		(void) new TDEListViewItem( listView,
															tmpPGN.TAG_Result,
															tmpPGN.TAG_White,
															tmpPGN.TAG_Black,
															tmpPGN.TAG_Round,
															tmpPGN.TAG_Site,
															tmpPGN.TAG_Date,
															TQString::number(tmpPGN.File_Position) );
		status->message( i18n( "%1 matches found." ).arg( listView->childCount() ) );
	}
}
