/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2004-10-01
 * Description : a kipi plugin to batch process images
 *
 * Copyright (C) 2004-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// Include files for TQt

#include <tqpainter.h>
#include <tqlistview.h>

// Include files for KDE

#include <tdelocale.h>

// Local includes

#include "batchprocessimagesitem.h"

namespace KIPIBatchProcessImagesPlugin
{

BatchProcessImagesItem::BatchProcessImagesItem(TQListView * parent, TQString const & pathSrc,
                        TQString const & nameSrc, TQString const & nameDest, TQString const & result)
                      : TDEListViewItem( parent, "", nameSrc, nameDest, result),
                        _pathSrc(pathSrc), _nameSrc(nameSrc), _nameDest(nameDest), _result(result),
                        _overwrote( false ),
                        _reverseSort( false )
{
    setText(0, pathSrc.section('/', -2, -2));
}

BatchProcessImagesItem::~BatchProcessImagesItem()
{
}

TQString BatchProcessImagesItem::pathSrc()                   { return _pathSrc;    }
TQString BatchProcessImagesItem::nameSrc()                   { return _nameSrc;    }
TQString BatchProcessImagesItem::nameDest()                  { return _nameDest;   }
TQString BatchProcessImagesItem::result()                    { return _result;     }
TQString BatchProcessImagesItem::error()                     { return _error;      }
TQString BatchProcessImagesItem::outputMess()                { return _outputMess; }

void BatchProcessImagesItem::changeResult(TQString text)     { setText(3, text); }
void BatchProcessImagesItem::changeError(TQString text)      { _error = text; }
void BatchProcessImagesItem::changeNameDest(TQString text)   { _nameDest = text; setText(2, _nameDest); }
void BatchProcessImagesItem::changeOutputMess(TQString text) { _outputMess.append(text); }

void BatchProcessImagesItem::paintCell (TQPainter *p, const TQColorGroup &cg, int column, int width, int alignment)
{
    TQColorGroup _cg( cg );

    if (text(3) != i18n("OK") && !text(3).isEmpty() )
       {
       _cg.setColor( TQColorGroup::Text, TQt::red );
       TDEListViewItem::paintCell( p, _cg, column, width, alignment );
       return;
       }
    if (text(3) == i18n("OK") )
       {
       _cg.setColor( TQColorGroup::Text, TQt::darkGreen );
       TDEListViewItem::paintCell( p, _cg, column, width, alignment );
       return;
       }

    TDEListViewItem::paintCell( p, cg, column, width, alignment );
}

bool BatchProcessImagesItem::overWrote()
{
    return _overwrote;
}

void BatchProcessImagesItem::setDidOverWrite( bool b )
{
    _overwrote = b;
}

void BatchProcessImagesItem::setKey(const TQString& val, bool reverseSort)
{
    _key = val;
    _reverseSort = reverseSort;
}

TQString BatchProcessImagesItem::key(int column, bool ) const
{
    if (_key.isNull())
        return text(column);

    return _key;
}

int BatchProcessImagesItem::compare(TQListViewItem * i, int col, bool ascending) const
{
    int weight = _reverseSort ? -1 : 1;
    return weight * key(col, ascending).localeAwareCompare(i->key( col, ascending));
}

}  // NameSpace KIPIBatchProcessImagesPlugin
