#include <tqmap.h>
#include <tqvaluelist.h>
#include <tqvaluevector.h>
#include <tqstring.h>
#include <tqrect.h>
#include <iostream>

template<typename T>
void test_sharing(const T& input)
{
	// a copy should increase the share counter
	T copy = input;

	// a const interator should not detach the copy
	typename T::const_iterator cit = copy.constBegin();
	std::cout << *cit << std::endl;

	// a non-const iterator should detach the copy
	typename T::iterator it = copy.begin();
	std::cout << *it << std::endl;
}

int main()
{
	TQMap<TQString,int> str2int;
	str2int["foo"] = 42;
	test_sharing(str2int);

	TQValueList<int> ints;
	ints.push_back(42);
	test_sharing(ints);

	TQValueVector<double> vals(6, 47.11);
	vals.push_back(42);
	test_sharing(vals);

	TQRect r(10,20, 130, 240);
	TQPoint p = r.topLeft();
	TQPoint q = r.bottomRight();
	std::cout << r.width() << r.height() << p.x() << q.y() << std::endl;
}
