/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KBIBTEXWEBQUERYBIBSONOMY_H
#define KBIBTEXWEBQUERYBIBSONOMY_H

#include "webquery.h"

namespace KBibTeX
{
    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQueryBibSonomyWidget : public WebQueryWidget
    {
        TQ_OBJECT
    public:
        WebQueryBibSonomyWidget( TQWidget *parent, const char *name = 0 );
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */

    class WebQueryBibSonomy : public WebQuery
    {
        TQ_OBJECT
    public:
        WebQueryBibSonomy( TQWidget* parent );
        virtual ~WebQueryBibSonomy();

        void query();

        TQString title();
        TQString disclaimer();
        TQString disclaimerURL();

        WebQueryWidget *widget();

    protected:
        void cancelQuery() { /* nothing */ };

    private:
        WebQueryBibSonomyWidget *m_widget;
    };
}

#endif
