/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                :  robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file has been modified to match the requirements of KBibTeX.     *
 *   In case of problems or bugs arising from this implementation, please  *
 *   contact the KBibTeX team first.                                       *
 *                             Thomas Fischer <fischer@unix-ag.uni-kl.de>  *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef KBIBTEX_MESSAGEHANDLER_H
#define KBIBTEX_MESSAGEHANDLER_H

class TQString;
class TQStringList;

namespace KBibTeX {

/**
 * @author Robby Stephenson
 */
class MessageHandler {
public:
  enum Type { Status, Warning, Error, ListError };

  MessageHandler() {}
  virtual ~MessageHandler() {}

  virtual void send(const TQString& message, Type type) = 0;
  virtual void infoList(const TQString& message, const TQStringList& list) = 0;
};

class ManagerMessage : public MessageHandler {
public:
  ManagerMessage() : MessageHandler() {}
  virtual ~ManagerMessage() {}

  virtual void send(const TQString& message, Type type);
  virtual void infoList(const TQString& message, const TQStringList& list);
};

} // end namespace

#endif
