/***************************************************************************
                         propertywidget.h  -  description
                             -------------------
    begin                : Do Sep 10 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
                                                                          
    This program is free software; you can redistribute it and/or modify  
    it under the terms of the GNU General Public License as published by  
    the Free Software Foundation; either version 2 of the License, or     
    (at your option) any later version.                                   
                                                                          
 ***************************************************************************/
 
#ifndef PROPERTYWIDGET_H
#define PROPERTYWIDGET_H

#include <tqwidget.h>
#include "labelutils.h"

class BarcodeWidget;
class DocumentItem;
class KColorButton;
class KComboBox;
class KIntNumInput;
class KDoubleNumInput;
class KMacroCommand;
class KTextEdit;
class MultiLineEditor;
class TQCheckBox;
class TQGridLayout;
class TQRadioButton;
//NY23
class TextLineEditor;
//NY23
class TokenProvider;

class TQHBox;
class KURLRequester;
class KLineEdit;
class KPushButton;

/**
@author Dominik Seichter
*/
class PropertyWidget : public TQWidget
{
    TQ_OBJECT
  
    public:
        PropertyWidget( TQWidget* parent );

        virtual void applySettings( DocumentItem* item, KMacroCommand* command ) = 0;
        virtual void initSettings( DocumentItem* item ) = 0;
    
    protected:
        TQGridLayout* grid;
};

class PropertyBorder : public PropertyWidget {
    TQ_OBJECT
  
    public:
        PropertyBorder( TQWidget* parent );

        virtual void applySettings( DocumentItem* item, KMacroCommand* command );
        virtual void initSettings( DocumentItem* item );

    private slots:
        void enableControls();
        
    private:
        KColorButton* buttonColor;
        KComboBox* comboLine;
        KIntNumInput* spinWidth;    
        TQCheckBox* checkBorder;
};

class PropertyRotation : public PropertyWidget {
    TQ_OBJECT
  
    public:
        PropertyRotation( TQWidget* parent );

        virtual void applySettings( DocumentItem* item, KMacroCommand* command );
        virtual void initSettings( DocumentItem* item );

    private:        
        KComboBox* comboRotation;
};

class PropertyFill : public PropertyWidget {
    TQ_OBJECT
  
    public:
        PropertyFill( TQWidget* parent );

        virtual void applySettings( DocumentItem* item, KMacroCommand* command );
        virtual void initSettings( DocumentItem* item );
        
    private:
        KColorButton* buttonColor;
};

class PropertyBarcode : public PropertyWidget, private LabelUtils {
    TQ_OBJECT
  
    public:
        PropertyBarcode( TokenProvider* token, TQWidget* parent );

        virtual void applySettings( DocumentItem* item, KMacroCommand* command );
        virtual void initSettings( DocumentItem* item );

    private slots:
        void changedCombo();
        
    private:
        KComboBox* comboComplex;
        BarcodeWidget* barcode;
};

class PropertyText : public PropertyWidget, private LabelUtils {
    TQ_OBJECT
  
    public:
        PropertyText( TokenProvider* token, TQWidget* parent );

        virtual void applySettings( DocumentItem* item, KMacroCommand* command );
        virtual void initSettings( DocumentItem* item );

    private:
        MultiLineEditor* m_editor;
};

//NY22
class PropertyTextLine : public PropertyWidget, private LabelUtils {
    TQ_OBJECT
  
    public:
        PropertyTextLine( TokenProvider* token, TQWidget* parent );

        virtual void applySettings( DocumentItem* item, KMacroCommand* command );
        virtual void initSettings( DocumentItem* item );

    private:
        TextLineEditor* m_editor;
};
//NY22

class PropertySize : public PropertyWidget, private LabelUtils {
    TQ_OBJECT
  
    public:
        PropertySize( TQWidget* parent );
        
        virtual void applySettings( DocumentItem* item, KMacroCommand* command );
        virtual void initSettings( DocumentItem* item );
    
    private slots:
        void enableControls();
        
    private:
        TQCheckBox* checkLock;
        KDoubleNumInput* numTop;
        KDoubleNumInput* numLeft;
        KDoubleNumInput* numWidth;
        KDoubleNumInput* numHeight;
};

class PropertyImage : public PropertyWidget {
    TQ_OBJECT
  
    public:
        PropertyImage( TokenProvider* token, TQWidget* parent );
        
        virtual void applySettings( DocumentItem* item, KMacroCommand* command );
        virtual void initSettings( DocumentItem* item );

    private slots:
	void enableControls();
        void slotTokens();

    private:
        TokenProvider* m_token;

        TQCheckBox* checkMirrorH;
        TQCheckBox* checkMirrorV;
	
	TQHBox* imgHBox;

        KComboBox* comboRotation;
	KURLRequester* imgUrl;
	KLineEdit* imgExpression;
	KPushButton* buttonToken;

	TQRadioButton* radioImagePath;
	TQRadioButton* radioImageExpression;

        TQRadioButton* radioOriginal;
        TQRadioButton* radioScaled;
        TQRadioButton* radioZoomed;        
};

class PropertyVisible : public PropertyWidget {
    TQ_OBJECT
  
    public:
        PropertyVisible( TQWidget* parent );
        
        virtual void applySettings( DocumentItem* item, KMacroCommand* command );
        virtual void initSettings( DocumentItem* item );

    private:
	KTextEdit* m_script;
};

#endif
