/***************************************************************************
                          dsmainwindow.cpp  -  description
                             -------------------
    begin                : Fri Jan 17 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dsmainwindow.h"
#include "sqltables.h"
#include "confwizard.h"
#include "printersettings.h"
#include "kbarcodesettings.h"
#include "barkode.h"

// TQt includes
#include <tqcheckbox.h>
#include <tqtextbrowser.h>
#include <tqsqldatabase.h>

// KDE includes
#include <tdeaction.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdemenubar.h>
#include <tdemessagebox.h>
#include <tdepopupmenu.h>
#include <kstandarddirs.h>
#include <krun.h>

bool DSMainWindow::autoconnect = true;
bool DSMainWindow::startwizard = true;

DSMainWindow::DSMainWindow(TQWidget *parent, const char *name, WFlags f)
    : TDEMainWindow(parent,name,f)
{
    connectAct = 0;
    first = false;
    loadConfig();

    setAutoSaveSettings( TQString("Window") + name, true );
    connect( kapp, TQ_SIGNAL( aboutToQuit() ), this,  TQ_SLOT( saveConfig() ) );

    if( first && startwizard ) {
        wizard();
        startwizard = false;
    }
    
}

DSMainWindow::~DSMainWindow()
{
}

void DSMainWindow::setupActions()
{
    TDEAction* quitAct = KStdAction::quit(kapp, TQ_SLOT(quit()), actionCollection());
    TDEAction* closeAct = KStdAction::close( this, TQ_SLOT( close() ), actionCollection(), "close" );
    TDEAction* configureAct = KStdAction::preferences( KBarcodeSettings::getInstance(), TQ_SLOT(configure()), actionCollection() );
    TDEAction* wizardAct = new TDEAction( i18n("&Start Configuration Wizard..."), BarIcon("wizard"), 0, this, 
                                TQ_SLOT(wizard()), actionCollection(), "wizard" );

    connectAct = new TDEAction(i18n("&Connect to Database"), BarIcon("connect_no"), 0, this,  TQ_SLOT(connectMySQL()),
                                actionCollection(),"connect" );


    TDEAction* newTablesAct = new TDEAction( i18n("&Create Tables"), "", 0, this, 
                                TQ_SLOT(newTables()), actionCollection(), "tables" );

    importLabelDefAct = new TDEAction( i18n("&Import Label Definitions"), "", 0, SqlTables::getInstance(),
                                TQ_SLOT(importLabelDef()), actionCollection(), "import" );

    importExampleAct = new TDEAction( i18n("&Import Example Data"), "", 0, SqlTables::getInstance(),
                                TQ_SLOT(importExampleData()), actionCollection(), "import" );
                                
    TDEPopupMenu* file = new TDEPopupMenu( this );
    TDEPopupMenu* settings = new TDEPopupMenu( this );
    TDEPopupMenu* hlpMenu = helpMenu();
    int helpid = hlpMenu->idAt( 0 );
    hlpMenu->removeItem( helpid );
    hlpMenu->insertItem( SmallIconSet("contents"), i18n("&Help"),
        this, TQ_SLOT(appHelpActivated()), Key_F1, -1, 0 );
    hlpMenu->insertItem( SmallIconSet("barcode"), i18n("&Barcode Help..."), this, TQ_SLOT( startInfo() ), 0, -1, 1 );
    hlpMenu->insertSeparator(3);
    hlpMenu->insertItem( i18n("&Donate..."), this, TQ_SLOT( donations() ), 0, -1, 4 );
    hlpMenu->insertSeparator(5);
    hlpMenu->insertItem( SmallIconSet("computer"), i18n("&System Check..."), this, TQ_SLOT(showCheck() ), 0, -1, 6 );
    menuBar()->insertItem( i18n("&File"), file );
    menuBar()->insertItem( i18n("&Settings"), settings );
    menuBar()->insertItem( i18n("&Help"), hlpMenu );

    closeAct->plug( file );
    quitAct->plug( file );

    configureAct->plug( settings );
    wizardAct->plug( settings );
    connectAct->plug( settings );
    (new TDEActionSeparator( this ))->plug( settings );
    newTablesAct->plug( settings );
    importLabelDefAct->plug( settings );
    importExampleAct->plug( settings );

    SqlTables* tables = SqlTables::getInstance();
    if( tables->getData().autoconnect && autoconnect && !first ) {
        tables->connectMySQL();
        autoconnect = false;
    }

    connectAct->setEnabled( !SqlTables::isConnected() );
    importLabelDefAct->setEnabled( !connectAct->isEnabled() );
    importExampleAct->setEnabled( !connectAct->isEnabled() );
}

void DSMainWindow::loadConfig()
{
    TDEConfig* config = kapp->config();

    config->setGroup("Wizard");
    first = config->readBoolEntry("firststart2", true );

    SqlTables* tables = SqlTables::getInstance();
    if( tables->getData().autoconnect && !first && autoconnect && connectAct ) {
        connectAct->setEnabled( !tables->connectMySQL() );
        importLabelDefAct->setEnabled( !connectAct->isEnabled() );
        importExampleAct->setEnabled( !connectAct->isEnabled() );

        autoconnect = false;
    }

    KBarcodeSettings::getInstance()->loadConfig();
}

void DSMainWindow::saveConfig()
{
    TDEConfig* config = kapp->config();

    config->setGroup("Wizard");
    config->writeEntry("firststart2", false );

    PrinterSettings::getInstance()->saveConfig();
    SqlTables::getInstance()->saveConfig();
    KBarcodeSettings::getInstance()->saveConfig();

    config->sync();
}

void DSMainWindow::wizard()
{
    ConfWizard* wiz = new ConfWizard( 0, "wiz", true );
    if( wiz->exec() == TQDialog::Accepted && wiz->checkDatabase->isChecked() )
        SqlTables::getInstance()->connectMySQL();

    delete wiz;
}

void DSMainWindow::connectMySQL()
{
    connectAct->setEnabled( !SqlTables::getInstance()->connectMySQL() );
    importLabelDefAct->setEnabled( !connectAct->isEnabled() );
    importExampleAct->setEnabled( !connectAct->isEnabled() );

    if( !connectAct->isEnabled() )
        emit connectedSQL();
}

void DSMainWindow::appHelpActivated()
{
    KMessageBox::information( this, i18n(
        "<qt>The KBarcode documentation is avaible as PDF for download here.<br><br>") +
        "<a href=\"https://gentoo.ussg.indiana.edu/distfiles/kbarcode-2.0.0.pdf\">" +
        i18n("Download Now") + "</a></qt>",
        TQString(), TQString(), KMessageBox::AllowLink );
}

void DSMainWindow::showCheck()
{
    TQTextBrowser* b = new TQTextBrowser( 0, "b" );
    b->setText( DSMainWindow::systemCheck() );
    b->resize( 320, 240 );
    b->show();
}

void DSMainWindow::startInfo()
{
    TQString info = locate("appdata", "barcodes.html");
    if( !info.isEmpty() )
        kapp->invokeBrowser( info );
}

bool DSMainWindow::newTables()
{
    return SqlTables::getInstance()->newTables();
}

void DSMainWindow::donations()
{
    TQString url = "https://trinitydesktop.org/donate.php";

    KMessageBox::information( this, i18n(
        "<qt>It is possible to support the further development of KBarcode through donations.<br><br>" ) +
        "<a href=\"" + url + "\">" +
        i18n("Donate Now") + "</a></qt>", TQString(), TQString(), KMessageBox::AllowLink );
}

TQString DSMainWindow::systemCheck()
{
    bool gnubarcode = !Barkode::haveGNUBarcode();
    bool pdf = !Barkode::havePDFBarcode();
    bool tbarcode = !Barkode::haveTBarcode();
    bool tbarcode2 = !Barkode::haveTBarcode2();
    bool pure = !Barkode::havePurePostscriptBarcode();

    TQString text;

    text.append( i18n("<p><h3>Barcode Support</h3></p>") );
    text.append( "<p>GNU Barcode: ");
    text.append(  gnubarcode ? i18n("<b>No</b><br />") : i18n("<b>Found</b><br />") );
    text.append( "PDF417 Encode: ");
    text.append( pdf ? i18n("<b>No</b><br />") : i18n("<b>Found</b><br />") );
    text.append( "TBarcode: ");
    text.append( tbarcode ? i18n("<b>No</b><br />") : i18n("<b>Found</b><br />") );
    text.append( "TBarcode2: ");
    text.append( tbarcode2 ? i18n("<b>No</b><br />") : i18n("<b>Found</b><br />") );
    text.append( "Pure Postscript Barcode Writer: ");
    text.append( pure ? i18n("<b>No</b><br />") : i18n("<b>Found</b><br />") );

    if( gnubarcode && tbarcode && pdf )
        text.append( i18n("<p>To get <b>barcode support</b> you have to install <i>GNU Barcode</i>, <i>TBarcode</i> or <i>PDF417 Enc</i>.</p>") );

    text.append( i18n("<p><h3>Database Support</h3></p>") );

    TQStringList list = TQSqlDatabase::drivers();

    if( list.count() ) {
        text.append( "<ul>" );
        TQStringList::Iterator it = list.begin();
        while( it != list.end() ) {
            text.append( i18n("<li>Driver found: ") + *it + "</li>" );
            ++it;
        }
        text.append( "</ul>" );
    } else
        text.append( i18n("<p><b>No database drivers found. SQL database support is disabled.</b></p>") );

    return text;
}

#include "dsmainwindow.moc"
