/*
 * disc.h
 *
 * Copyright (C) 2006 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef DISC_H
#define DISC_H

#include <tdeaction.h>
#include <kstdaction.h>
#include <tdeconfig.h>
#include <tdelistview.h>

#include <tqframe.h>
#include <tqvbox.h>
#include <tqsplitter.h>
#include <tqtoolbutton.h>
#include <tqlabel.h>
#include <tqpixmap.h>
#include <tqprogressbar.h>
#include <tqguardedptr.h>

#include "kaffeineinput.h"
#include "paranoia.h"

class MRL;

class MLabel : public TQLabel
{
	TQ_OBJECT
  

public:
	MLabel( TQWidget *parent );
	~MLabel() {}

protected:
	void paintEvent( TQPaintEvent * );
};



class MListView : public TDEListView
{
	TQ_OBJECT
  

public:
	MListView( TQWidget *parent );
	~MListView() {}

protected:
	virtual void resizeEvent(TQResizeEvent*);
};



class Disc : public KaffeineInput
{
	TQ_OBJECT
  

public:
	Disc(TQWidget *parent, TQObject *objParent, const char *name=0);
	~Disc();

	// Reimplemented from KaffeineInput
public:
	TQWidget *wantPlayerWindow();
	TQWidget *inputMainWidget();
	void mergeMeta(const MRL&);
	bool nextTrack( MRL& );
	bool previousTrack( MRL& );
	bool currentTrack( MRL& );
	bool trackNumber( int, MRL& );
	bool playbackFinished( MRL& );
	void toggleLayout( bool );
	void playerStopped();
	void getTargets( TQStringList &uiNames, TQStringList &iconNames, TQStringList &targetNames );
	void togglePanel();
	bool execTarget( const TQString& );
	void saveConfig();
	//***************************************

public slots:
	void startCD( const TQString &device="", bool rip=false );
	void startDVD( const TQString &device="" );
	void startVCD( const TQString &device="" );
	void startRIP();

public:
	TQVBox *mainWidget;
	TQVBox *playerBox;

private:
	void loadConfig( TDEConfig* config );
	void saveConfig( TDEConfig* config );
	void setCurrent( int n );
	void setupActions();

	TQLabel *artistLab, *albumLab;
	TQGuardedPtr<TQWidget> widg;
	TQToolButton *ripBtn, *cdBtn;
	TQToolButton *enc;
	TQSplitter *split;
	TQGuardedPtr<TQFrame> panel;
	MLabel *discLab;
	Paranoia *para;
	MListView *list;
	int trackCurrent;
	TQString currentDevice;
	TQPixmap currentPixmap;
	TQWidget *encodeWidget;
	TQTimer encodeTimer;
	TQProgressBar *progressBar;

private slots:
	void trackSelected( TQListViewItem* );
	void encode();
	void encodeProgress();
	void setEncoding( bool );

signals:
	void signalRequestForDVD();
	void signalRequestForVCD();
};

#endif /* DISC_H */
