/*
 * googlefetcher.h
 *
 * Copyright (C) 2004 Nathan Toone <nathan@toonetown.com>
 * Copyright (C) 2006 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef GOOGLEFETCHER_H
#define GOOGLEFETCHER_H

#include <kdialogbase.h>

#include <tqpixmap.h>
#include <tqstringlist.h>
#include <tqregexp.h>

namespace DOM {
    class HTMLDocument;
}

class KURL;

class GoogleImage
{
public:
    GoogleImage(TQString thumbURL = TQString(), TQString size = TQString());

    TQString imageURL() const { return m_imageURL; }
    TQString thumbURL() const { return m_thumbURL; }
    TQString size() const { return m_size; }

private:
    TQString m_imageURL;
    TQString m_thumbURL;
    TQString m_size;
};

typedef TQValueList<GoogleImage> GoogleImageList;

class GoogleFetcher : public TQObject
{
    TQ_OBJECT
  

public:
    enum ImageSize { All, Icon, Small, Medium, Large, XLarge };

    GoogleFetcher( TQString artist, TQString album, bool gallery=false );
    TQPixmap pixmap( bool forceFetch = false );
    TQImage galleryNext( bool &end );

signals:
    void signalNewSearch(GoogleImageList &images);

private:
    void displayWaitMessage();
    bool requestNewSearchTerms(bool noResults = false);

    // Returns true if there are results in the search, otherwise returns false.
    bool hasImageResults( TQString &doc );

private slots:
    void slotLoadImageURLs(GoogleFetcher::ImageSize size = All);

private:
    TQString m_artist, m_album;
    TQString m_searchString;
    TQString m_loadedQuery;
    ImageSize m_loadedSize;
    GoogleImageList m_imageList;
    uint m_selectedIndex;
    int encoding;
    int galleryImage;
    int galleryPage;
    bool galleryMode;
};

#endif /* GOOGLEFETCHER_H */
